/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public abstract class BasePretrainNetwork
extends FeedForwardLayer {
    protected LossFunctions.LossFunction lossFunction;
    protected String customLossFunction;

    public BasePretrainNetwork(Builder builder) {
        super(builder);
        this.lossFunction = builder.lossFunction;
        this.customLossFunction = builder.customLossFunction;
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return 0.0;
            }
            case "bB": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return 0.0;
            }
            case "bB": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
            case "bB": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public LossFunctions.LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public String getCustomLossFunction() {
        return this.customLossFunction;
    }

    public void setLossFunction(LossFunctions.LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public void setCustomLossFunction(String customLossFunction) {
        this.customLossFunction = customLossFunction;
    }

    public BasePretrainNetwork() {
    }

    @Override
    public String toString() {
        return "BasePretrainNetwork(super=" + super.toString() + ", lossFunction=" + this.getLossFunction() + ", customLossFunction=" + this.getCustomLossFunction() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePretrainNetwork)) {
            return false;
        }
        BasePretrainNetwork other = (BasePretrainNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LossFunctions.LossFunction this$lossFunction = this.getLossFunction();
        LossFunctions.LossFunction other$lossFunction = other.getLossFunction();
        if (this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction)) {
            return false;
        }
        String this$customLossFunction = this.getCustomLossFunction();
        String other$customLossFunction = other.getCustomLossFunction();
        return !(this$customLossFunction == null ? other$customLossFunction != null : !this$customLossFunction.equals(other$customLossFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BasePretrainNetwork;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        LossFunctions.LossFunction $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 0 : $lossFunction.hashCode());
        String $customLossFunction = this.getCustomLossFunction();
        result = result * 59 + ($customLossFunction == null ? 0 : $customLossFunction.hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends FeedForwardLayer.Builder<T> {
        protected LossFunctions.LossFunction lossFunction = LossFunctions.LossFunction.RECONSTRUCTION_CROSSENTROPY;
        protected String customLossFunction = null;

        public T lossFunction(LossFunctions.LossFunction lossFunction) {
            this.lossFunction = lossFunction;
            return (T)this;
        }

        public T customLossFunction(String customLossFunction) {
            this.customLossFunction = customLossFunction;
            return (T)this;
        }
    }
}

