/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.earlystopping.EarlyStoppingModelSaver;
import org.deeplearning4j.earlystopping.saver.InMemoryModelSaver;
import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.deeplearning4j.nn.api.Model;

public class EarlyStoppingConfiguration<T extends Model>
implements Serializable {
    private EarlyStoppingModelSaver<T> modelSaver;
    private List<EpochTerminationCondition> epochTerminationConditions;
    private List<IterationTerminationCondition> iterationTerminationConditions;
    private boolean saveLastModel;
    private int evaluateEveryNEpochs;
    private ScoreCalculator<T> scoreCalculator;

    private EarlyStoppingConfiguration(Builder<T> builder) {
        this.modelSaver = ((Builder)builder).modelSaver;
        this.epochTerminationConditions = ((Builder)builder).epochTerminationConditions;
        this.iterationTerminationConditions = ((Builder)builder).iterationTerminationConditions;
        this.saveLastModel = ((Builder)builder).saveLastModel;
        this.evaluateEveryNEpochs = ((Builder)builder).evaluateEveryNEpochs;
        this.scoreCalculator = ((Builder)builder).scoreCalculator;
    }

    public EarlyStoppingModelSaver<T> getModelSaver() {
        return this.modelSaver;
    }

    public List<EpochTerminationCondition> getEpochTerminationConditions() {
        return this.epochTerminationConditions;
    }

    public List<IterationTerminationCondition> getIterationTerminationConditions() {
        return this.iterationTerminationConditions;
    }

    public boolean isSaveLastModel() {
        return this.saveLastModel;
    }

    public int getEvaluateEveryNEpochs() {
        return this.evaluateEveryNEpochs;
    }

    public ScoreCalculator<T> getScoreCalculator() {
        return this.scoreCalculator;
    }

    public void setModelSaver(EarlyStoppingModelSaver<T> modelSaver) {
        this.modelSaver = modelSaver;
    }

    public void setEpochTerminationConditions(List<EpochTerminationCondition> epochTerminationConditions) {
        this.epochTerminationConditions = epochTerminationConditions;
    }

    public void setIterationTerminationConditions(List<IterationTerminationCondition> iterationTerminationConditions) {
        this.iterationTerminationConditions = iterationTerminationConditions;
    }

    public void setSaveLastModel(boolean saveLastModel) {
        this.saveLastModel = saveLastModel;
    }

    public void setEvaluateEveryNEpochs(int evaluateEveryNEpochs) {
        this.evaluateEveryNEpochs = evaluateEveryNEpochs;
    }

    public void setScoreCalculator(ScoreCalculator<T> scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EarlyStoppingConfiguration)) {
            return false;
        }
        EarlyStoppingConfiguration other = (EarlyStoppingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EarlyStoppingModelSaver<T> this$modelSaver = this.getModelSaver();
        EarlyStoppingModelSaver<T> other$modelSaver = other.getModelSaver();
        if (this$modelSaver == null ? other$modelSaver != null : !this$modelSaver.equals(other$modelSaver)) {
            return false;
        }
        List<EpochTerminationCondition> this$epochTerminationConditions = this.getEpochTerminationConditions();
        List<EpochTerminationCondition> other$epochTerminationConditions = other.getEpochTerminationConditions();
        if (this$epochTerminationConditions == null ? other$epochTerminationConditions != null : !((Object)this$epochTerminationConditions).equals(other$epochTerminationConditions)) {
            return false;
        }
        List<IterationTerminationCondition> this$iterationTerminationConditions = this.getIterationTerminationConditions();
        List<IterationTerminationCondition> other$iterationTerminationConditions = other.getIterationTerminationConditions();
        if (this$iterationTerminationConditions == null ? other$iterationTerminationConditions != null : !((Object)this$iterationTerminationConditions).equals(other$iterationTerminationConditions)) {
            return false;
        }
        if (this.isSaveLastModel() != other.isSaveLastModel()) {
            return false;
        }
        if (this.getEvaluateEveryNEpochs() != other.getEvaluateEveryNEpochs()) {
            return false;
        }
        ScoreCalculator<T> this$scoreCalculator = this.getScoreCalculator();
        ScoreCalculator<T> other$scoreCalculator = other.getScoreCalculator();
        return !(this$scoreCalculator == null ? other$scoreCalculator != null : !this$scoreCalculator.equals(other$scoreCalculator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EarlyStoppingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EarlyStoppingModelSaver<T> $modelSaver = this.getModelSaver();
        result = result * 59 + ($modelSaver == null ? 0 : $modelSaver.hashCode());
        List<EpochTerminationCondition> $epochTerminationConditions = this.getEpochTerminationConditions();
        result = result * 59 + ($epochTerminationConditions == null ? 0 : ((Object)$epochTerminationConditions).hashCode());
        List<IterationTerminationCondition> $iterationTerminationConditions = this.getIterationTerminationConditions();
        result = result * 59 + ($iterationTerminationConditions == null ? 0 : ((Object)$iterationTerminationConditions).hashCode());
        result = result * 59 + (this.isSaveLastModel() ? 79 : 97);
        result = result * 59 + this.getEvaluateEveryNEpochs();
        ScoreCalculator<T> $scoreCalculator = this.getScoreCalculator();
        result = result * 59 + ($scoreCalculator == null ? 0 : $scoreCalculator.hashCode());
        return result;
    }

    public String toString() {
        return "EarlyStoppingConfiguration(modelSaver=" + this.getModelSaver() + ", epochTerminationConditions=" + this.getEpochTerminationConditions() + ", iterationTerminationConditions=" + this.getIterationTerminationConditions() + ", saveLastModel=" + this.isSaveLastModel() + ", evaluateEveryNEpochs=" + this.getEvaluateEveryNEpochs() + ", scoreCalculator=" + this.getScoreCalculator() + ")";
    }

    public static class Builder<T extends Model> {
        private EarlyStoppingModelSaver<T> modelSaver = new InMemoryModelSaver();
        private List<EpochTerminationCondition> epochTerminationConditions = new ArrayList<EpochTerminationCondition>();
        private List<IterationTerminationCondition> iterationTerminationConditions = new ArrayList<IterationTerminationCondition>();
        private boolean saveLastModel = false;
        private int evaluateEveryNEpochs = 1;
        private ScoreCalculator<T> scoreCalculator;

        public Builder<T> modelSaver(EarlyStoppingModelSaver<T> modelSaver) {
            this.modelSaver = modelSaver;
            return this;
        }

        public Builder<T> epochTerminationConditions(EpochTerminationCondition ... terminationConditions) {
            this.epochTerminationConditions.clear();
            Collections.addAll(this.epochTerminationConditions, terminationConditions);
            return this;
        }

        public Builder<T> epochTerminationConditions(List<EpochTerminationCondition> terminationConditions) {
            this.epochTerminationConditions = terminationConditions;
            return this;
        }

        public Builder<T> iterationTerminationConditions(IterationTerminationCondition ... terminationConditions) {
            this.iterationTerminationConditions.clear();
            Collections.addAll(this.iterationTerminationConditions, terminationConditions);
            return this;
        }

        public Builder<T> saveLastModel(boolean saveLastModel) {
            this.saveLastModel = saveLastModel;
            return this;
        }

        public Builder<T> evaluateEveryNEpochs(int everyNEpochs) {
            this.evaluateEveryNEpochs = everyNEpochs;
            return this;
        }

        public Builder<T> scoreCalculator(ScoreCalculator<T> scoreCalculator) {
            this.scoreCalculator = scoreCalculator;
            return this;
        }

        public EarlyStoppingConfiguration<T> build() {
            return new EarlyStoppingConfiguration(this);
        }
    }
}

