/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.transformers.impl.iterables;

import java.util.Iterator;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTransformerIterator
implements Iterator<Sequence<VocabWord>> {
    private static final Logger log = LoggerFactory.getLogger(BasicTransformerIterator.class);
    protected final LabelAwareIterator iterator;
    protected boolean allowMultithreading;
    protected final SentenceTransformer sentenceTransformer;

    public BasicTransformerIterator(@NonNull LabelAwareIterator iterator, @NonNull SentenceTransformer transformer) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked @NonNull but is null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer is marked @NonNull but is null");
        }
        this.iterator = iterator;
        this.allowMultithreading = false;
        this.sentenceTransformer = transformer;
        this.iterator.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNextDocument();
    }

    @Override
    public Sequence<VocabWord> next() {
        LabelledDocument document = this.iterator.nextDocument();
        if (document == null || document.getContent() == null) {
            return new Sequence<VocabWord>();
        }
        Sequence<VocabWord> sequence = this.sentenceTransformer.transformToSequence(document.getContent());
        if (document.getLabels() != null) {
            for (String label : document.getLabels()) {
                if (label == null || label.isEmpty()) continue;
                sequence.addSequenceLabel(new VocabWord(1.0, label));
            }
        }
        return sequence;
    }

    public void reset() {
        this.iterator.reset();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

