/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.models.embeddings.learning.impl.elements.BatchItem;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSequences<T extends SequenceElement> {
    private static final Logger log = LoggerFactory.getLogger(BatchSequences.class);
    private int batches;
    List<BatchItem<T>> buffer = new ArrayList<BatchItem<T>>();

    public BatchSequences(int batches) {
        this.batches = batches;
    }

    public void put(T word, T lastWord, long randomValue, double alpha) {
        BatchItem<T> newItem = new BatchItem<T>(word, lastWord, randomValue, alpha);
        this.buffer.add(newItem);
    }

    public void put(T word, int[] windowWords, boolean[] wordStatuses, long randomValue, double alpha) {
        BatchItem<T> newItem = new BatchItem<T>(word, windowWords, wordStatuses, randomValue, alpha);
        this.buffer.add(newItem);
    }

    public void put(T word, int[] windowWords, boolean[] wordStatuses, long randomValue, double alpha, int numLabels) {
        BatchItem<T> newItem = new BatchItem<T>(word, windowWords, wordStatuses, randomValue, alpha, numLabels);
        this.buffer.add(newItem);
    }

    public List<BatchItem<T>> get(int chunkNo) {
        ArrayList<BatchItem<T>> retVal = new ArrayList<BatchItem<T>>();
        for (int i = 0 + chunkNo * this.batches; i < this.batches + chunkNo * this.batches && i < this.buffer.size(); ++i) {
            BatchItem<T> value = this.buffer.get(i);
            retVal.add(value);
        }
        return retVal;
    }

    public int size() {
        return this.buffer.size();
    }

    public void clear() {
        this.buffer.clear();
    }
}

