/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import lombok.NonNull;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class BasicLineIterator
implements SentenceIterator,
Iterable<String> {
    private BufferedReader reader;
    private InputStream backendStream;
    private SentencePreProcessor preProcessor;
    private boolean internal = false;

    public BasicLineIterator(@NonNull File file) throws FileNotFoundException {
        this(new FileInputStream(file));
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        this.internal = true;
    }

    public BasicLineIterator(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked @NonNull but is null");
        }
        this.backendStream = stream;
        this.reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.backendStream, 0xA00000)));
    }

    public BasicLineIterator(@NonNull String filePath) throws FileNotFoundException {
        this(new FileInputStream(filePath));
        if (filePath == null) {
            throw new NullPointerException("filePath is marked @NonNull but is null");
        }
        this.internal = true;
    }

    @Override
    public synchronized String nextSentence() {
        try {
            return this.preProcessor != null ? this.preProcessor.preProcess(this.reader.readLine()) : this.reader.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        try {
            return this.reader.ready();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public synchronized void reset() {
        try {
            if (this.backendStream instanceof FileInputStream) {
                ((FileInputStream)this.backendStream).getChannel().position(0L);
            } else {
                this.backendStream.reset();
            }
            this.reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.backendStream, 102400)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finish() {
        try {
            if (this.internal && this.backendStream != null) {
                this.backendStream.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.internal && this.backendStream != null) {
                this.backendStream.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.finalize();
    }

    @Override
    public Iterator<String> iterator() {
        this.reset();
        Iterator<String> ret = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return BasicLineIterator.this.hasNext();
            }

            @Override
            public String next() {
                return BasicLineIterator.this.nextSentence();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return ret;
    }
}

