/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore.inmemory;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.movingwindow.Util;
import org.nd4j.linalg.primitives.Counter;
import org.nd4j.linalg.util.SerializationUtils;
import org.nd4j.util.Index;

@Deprecated
public class InMemoryLookupCache
implements VocabCache<VocabWord>,
Serializable {
    private Index wordIndex = new Index();
    public Counter<String> wordFrequencies = Util.parallelCounter();
    public Counter<String> docFrequencies = Util.parallelCounter();
    public Map<String, VocabWord> vocabs = new ConcurrentHashMap<String, VocabWord>();
    public Map<String, VocabWord> tokens = new ConcurrentHashMap<String, VocabWord>();
    private final AtomicLong totalWordOccurrences = new AtomicLong(0L);
    private int numDocs = 0;

    public synchronized void setWordFrequencies(Counter<String> cnt) {
        this.wordFrequencies = cnt;
    }

    public synchronized Map<String, VocabWord> getVocabs() {
        return this.vocabs;
    }

    public synchronized void setVocabs(Map<String, VocabWord> vocabs) {
        this.vocabs = vocabs;
    }

    public synchronized Counter<String> getWordFrequencies() {
        return this.wordFrequencies;
    }

    public synchronized void setTokens(Map<String, VocabWord> tokens) {
        this.tokens = tokens;
    }

    public synchronized Map<String, VocabWord> getTokens() {
        return this.tokens;
    }

    public InMemoryLookupCache() {
    }

    @Deprecated
    public InMemoryLookupCache(boolean addUnk) {
    }

    @Override
    public synchronized Collection<String> words() {
        return this.vocabs.keySet();
    }

    @Override
    public synchronized void incrementWordCount(String word) {
        this.incrementWordCount(word, 1);
    }

    @Override
    public synchronized void incrementWordCount(String word, int increment) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        this.wordFrequencies.incrementCount((Object)word, (double)increment);
        if (this.hasToken(word)) {
            VocabWord token = this.tokenFor(word);
            token.increaseElementFrequency(increment);
        }
        this.totalWordOccurrences.set(this.totalWordOccurrences.get() + (long)increment);
    }

    @Override
    public synchronized int wordFrequency(String word) {
        return (int)this.wordFrequencies.getCount((Object)word);
    }

    @Override
    public synchronized boolean containsWord(String word) {
        return this.vocabs.containsKey(word);
    }

    @Override
    public synchronized String wordAtIndex(int index) {
        return (String)this.wordIndex.get(index);
    }

    @Override
    public VocabWord elementAtIndex(int index) {
        return this.wordFor(this.wordAtIndex(index));
    }

    @Override
    public synchronized int indexOf(String word) {
        if (this.containsWord(word)) {
            return this.wordFor(word).getIndex();
        }
        return -1;
    }

    @Override
    public synchronized Collection<VocabWord> vocabWords() {
        return this.vocabs.values();
    }

    @Override
    public synchronized long totalWordOccurrences() {
        return this.totalWordOccurrences.get();
    }

    @Override
    public synchronized VocabWord wordFor(String word) {
        if (word == null) {
            return null;
        }
        VocabWord ret = this.vocabs.get(word);
        return ret;
    }

    @Override
    public VocabWord wordFor(long id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void addWordToIndex(int index, String word) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        if (!this.tokens.containsKey(word)) {
            VocabWord token = new VocabWord(1.0, word);
            this.tokens.put(word, token);
            this.wordFrequencies.incrementCount((Object)word, 1.0);
        }
        if (!this.vocabs.containsKey(word)) {
            VocabWord vw = this.tokenFor(word);
            vw.setIndex(index);
            this.vocabs.put(word, vw);
            vw.setIndex(index);
        }
        if (!this.wordFrequencies.containsElement((Object)word)) {
            this.wordFrequencies.incrementCount((Object)word, 1.0);
        }
        this.wordIndex.add((Object)word, index);
    }

    @Override
    public void addWordToIndex(int index, long elementId) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public synchronized void putVocabWord(String word) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word can't be empty or null");
        }
        if (word.equals("STOP") || word.equals("UNK")) {
            return;
        }
        VocabWord token = this.tokenFor(word);
        if (token == null) {
            throw new IllegalStateException("Word " + word + " not found as token in vocab");
        }
        int ind = token.getIndex();
        this.addWordToIndex(ind, word);
        if (!this.hasToken(word)) {
            throw new IllegalStateException("Unable to add token " + word + " when not already a token");
        }
        this.vocabs.put(word, token);
        this.wordIndex.add((Object)word, token.getIndex());
    }

    @Override
    public synchronized int numWords() {
        return this.vocabs.size();
    }

    @Override
    public synchronized int docAppearedIn(String word) {
        return (int)this.docFrequencies.getCount((Object)word);
    }

    @Override
    public synchronized void incrementDocCount(String word, long howMuch) {
        this.docFrequencies.incrementCount((Object)word, (double)howMuch);
    }

    @Override
    public synchronized void setCountForDoc(String word, long count) {
        this.docFrequencies.setCount((Object)word, (double)count);
    }

    @Override
    public synchronized long totalNumberOfDocs() {
        return this.numDocs;
    }

    @Override
    public synchronized void incrementTotalDocCount() {
        ++this.numDocs;
    }

    @Override
    public synchronized void incrementTotalDocCount(long by) {
        this.numDocs = (int)((long)this.numDocs + by);
    }

    @Override
    public synchronized Collection<VocabWord> tokens() {
        return this.tokens.values();
    }

    @Override
    public synchronized void addToken(VocabWord word) {
        this.tokens.put(word.getLabel(), word);
    }

    @Override
    public synchronized VocabWord tokenFor(String word) {
        return this.tokens.get(word);
    }

    @Override
    public VocabWord tokenFor(long id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean hasToken(String token) {
        return this.tokenFor(token) != null;
    }

    @Override
    public void importVocabulary(VocabCache<VocabWord> vocabCache) {
        for (VocabWord word : vocabCache.vocabWords()) {
            if (this.vocabs.containsKey(word.getLabel())) {
                this.wordFrequencies.incrementCount((Object)word.getLabel(), (double)((float)word.getElementFrequency()));
            } else {
                this.tokens.put(word.getLabel(), word);
                this.vocabs.put(word.getLabel(), word);
                this.wordFrequencies.incrementCount((Object)word.getLabel(), (double)((float)word.getElementFrequency()));
            }
            this.totalWordOccurrences.addAndGet((long)word.getElementFrequency());
        }
    }

    @Override
    public void updateWordsOccurrences() {
        this.totalWordOccurrences.set(0L);
        for (VocabWord word : this.vocabWords()) {
            this.totalWordOccurrences.addAndGet((long)word.getElementFrequency());
        }
    }

    @Override
    public void removeElement(String label) {
        this.vocabs.remove(label);
        this.tokens.remove(label);
    }

    @Override
    public void removeElement(VocabWord element) {
        this.removeElement(element.getLabel());
    }

    @Override
    public synchronized void saveVocab() {
        SerializationUtils.saveObject((Object)this, (File)new File("ser"));
    }

    @Override
    public synchronized boolean vocabExists() {
        return new File("ser").exists();
    }

    public static InMemoryLookupCache load(InputStream from) {
        return null;
    }

    @Override
    public synchronized void loadVocab() {
        InMemoryLookupCache cache = (InMemoryLookupCache)SerializationUtils.readObject((File)new File("ser"));
        this.vocabs = cache.vocabs;
        this.wordFrequencies = cache.wordFrequencies;
        this.wordIndex = cache.wordIndex;
        this.tokens = cache.tokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryLookupCache that = (InMemoryLookupCache)o;
        if (this.numDocs != that.numDocs) {
            return false;
        }
        if (this.wordIndex != null ? !this.wordIndex.equals((Object)that.wordIndex) : that.wordIndex != null) {
            return false;
        }
        if (this.wordFrequencies != null ? !this.wordFrequencies.equals(that.wordFrequencies) : that.wordFrequencies != null) {
            return false;
        }
        if (this.docFrequencies != null ? !this.docFrequencies.equals(that.docFrequencies) : that.docFrequencies != null) {
            return false;
        }
        if (this.vocabWords().equals(that.vocabWords())) {
            return true;
        }
        return true;
    }

    public int hashCode() {
        int result = this.wordIndex != null ? this.wordIndex.hashCode() : 0;
        result = 31 * result + (this.wordFrequencies != null ? this.wordFrequencies.hashCode() : 0);
        result = 31 * result + (this.docFrequencies != null ? this.docFrequencies.hashCode() : 0);
        result = 31 * result + (this.vocabs != null ? this.vocabs.hashCode() : 0);
        result = 31 * result + (this.tokens != null ? this.tokens.hashCode() : 0);
        result = 31 * result + (this.totalWordOccurrences != null ? this.totalWordOccurrences.hashCode() : 0);
        result = 31 * result + this.numDocs;
        return result;
    }

    public String toString() {
        return "InMemoryLookupCache{totalWordOccurrences=" + this.totalWordOccurrences + ", numDocs=" + this.numDocs + '}';
    }
}

