/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.text.movingwindow.Window;
import org.deeplearning4j.text.tokenization.tokenizer.DefaultStreamTokenizer;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Windows {
    private static final Logger log = LoggerFactory.getLogger(Windows.class);

    private Windows() {
    }

    public static List<Window> windows(InputStream words, int windowSize) {
        DefaultStreamTokenizer tokenizer = new DefaultStreamTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(InputStream words, TokenizerFactory tokenizerFactory, int windowSize) {
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No tokens found for windows");
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words, int windowSize) {
        StringTokenizer tokenizer = new StringTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words, @NonNull TokenizerFactory tokenizerFactory, int windowSize, WordVectors vectors) {
        if (tokenizerFactory == null) {
            throw new NullPointerException("tokenizerFactory is marked non-null but is null");
        }
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (vectors.getWordVectorMatrix(token) == null) continue;
            list.add(token);
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No tokens found for windows");
        }
        return Windows.windows(list, windowSize);
    }

    public static List<Window> windows(String words) {
        StringTokenizer tokenizer = new StringTokenizer(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, 5);
    }

    public static List<Window> windows(String words, TokenizerFactory tokenizerFactory) {
        Tokenizer tokenizer = tokenizerFactory.create(words);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return Windows.windows(list, 5);
    }

    public static Window windowForWordInPosition(int windowSize, int wordPos, List<String> sentence) {
        ArrayList<String> window = new ArrayList<String>();
        ArrayList<String> onlyTokens = new ArrayList<String>();
        int contextSize = (int)Math.floor((windowSize - 1) / 2);
        for (int i = wordPos - contextSize; i <= wordPos + contextSize; ++i) {
            if (i < 0) {
                window.add("<s>");
                continue;
            }
            if (i >= sentence.size()) {
                window.add("</s>");
                continue;
            }
            onlyTokens.add(sentence.get(i));
            window.add(sentence.get(i));
        }
        String wholeSentence = StringUtils.join(sentence, (String)" ");
        String window2 = StringUtils.join(onlyTokens, (String)" ");
        int begin = wholeSentence.indexOf(window2);
        int end = begin + window2.length();
        return new Window(window, windowSize, begin, end);
    }

    public static List<Window> windows(List<String> words, int windowSize) {
        ArrayList<Window> ret = new ArrayList<Window>();
        for (int i = 0; i < words.size(); ++i) {
            ret.add(Windows.windowForWordInPosition(windowSize, i, words));
        }
        return ret;
    }
}

