/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import lombok.NonNull;
import org.deeplearning4j.models.word2vec.wordstore.HuffmanNode;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class VocabularyWord
implements Serializable {
    @NonNull
    private String word;
    private int count = 1;
    private double[] syn0;
    private double[] syn1;
    private double[] syn1Neg;
    private double[] historicalGradient;
    private static ObjectMapper mapper;
    private static final Object lock;
    private transient HuffmanNode huffmanNode;
    private transient byte[] frequencyShift;
    private transient byte retentionStep;
    private boolean special = false;

    public VocabularyWord() {
    }

    public VocabularyWord(@NonNull String word) {
        if (word == null) {
            throw new NullPointerException("word is marked non-null but is null");
        }
        this.word = word;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void incrementRetentionStep() {
        this.retentionStep = (byte)(this.retentionStep + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VocabularyWord word1 = (VocabularyWord)o;
        return this.word != null ? this.word.equals(word1.word) : word1.word == null;
    }

    public int hashCode() {
        return this.word != null ? this.word.hashCode() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper mapper() {
        if (mapper == null) {
            Object object = lock;
            synchronized (object) {
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
                    return mapper;
                }
            }
        }
        return mapper;
    }

    public String toJson() {
        ObjectMapper mapper = VocabularyWord.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static VocabularyWord fromJson(String json) {
        ObjectMapper mapper = VocabularyWord.mapper();
        try {
            VocabularyWord ret = (VocabularyWord)mapper.readValue(json, VocabularyWord.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public String getWord() {
        return this.word;
    }

    public int getCount() {
        return this.count;
    }

    public double[] getSyn0() {
        return this.syn0;
    }

    public double[] getSyn1() {
        return this.syn1;
    }

    public double[] getSyn1Neg() {
        return this.syn1Neg;
    }

    public double[] getHistoricalGradient() {
        return this.historicalGradient;
    }

    public HuffmanNode getHuffmanNode() {
        return this.huffmanNode;
    }

    public byte[] getFrequencyShift() {
        return this.frequencyShift;
    }

    public byte getRetentionStep() {
        return this.retentionStep;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setWord(@NonNull String word) {
        if (word == null) {
            throw new NullPointerException("word is marked non-null but is null");
        }
        this.word = word;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setSyn0(double[] syn0) {
        this.syn0 = syn0;
    }

    public void setSyn1(double[] syn1) {
        this.syn1 = syn1;
    }

    public void setSyn1Neg(double[] syn1Neg) {
        this.syn1Neg = syn1Neg;
    }

    public void setHistoricalGradient(double[] historicalGradient) {
        this.historicalGradient = historicalGradient;
    }

    public void setHuffmanNode(HuffmanNode huffmanNode) {
        this.huffmanNode = huffmanNode;
    }

    public void setFrequencyShift(byte[] frequencyShift) {
        this.frequencyShift = frequencyShift;
    }

    public void setRetentionStep(byte retentionStep) {
        this.retentionStep = retentionStep;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public String toString() {
        return "VocabularyWord(word=" + this.getWord() + ", count=" + this.getCount() + ", syn0=" + Arrays.toString(this.getSyn0()) + ", syn1=" + Arrays.toString(this.getSyn1()) + ", syn1Neg=" + Arrays.toString(this.getSyn1Neg()) + ", historicalGradient=" + Arrays.toString(this.getHistoricalGradient()) + ", huffmanNode=" + this.getHuffmanNode() + ", frequencyShift=" + Arrays.toString(this.getFrequencyShift()) + ", retentionStep=" + this.getRetentionStep() + ", special=" + this.isSpecial() + ")";
    }

    static {
        lock = new Object();
    }
}

