/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class Sequence<T extends SequenceElement>
implements Serializable {
    private static final long serialVersionUID = 2223750736522624735L;
    protected List<T> elements = new ArrayList<T>();
    protected Map<String, T> elementsMap = new LinkedHashMap<String, T>();
    protected List<T> labels = new ArrayList<T>();
    protected T label;
    protected int hash = 0;
    protected boolean hashCached = false;
    protected int sequenceId;

    public Sequence() {
    }

    public Sequence(@NonNull Collection<T> set) {
        this();
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        this.addElements(set);
    }

    public synchronized void addElement(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        this.hashCached = false;
        this.elementsMap.put(((SequenceElement)element).getLabel(), element);
        this.elements.add(element);
    }

    public void addElements(Collection<T> set) {
        for (SequenceElement element : set) {
            this.addElement(element);
        }
    }

    public List<String> asLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (SequenceElement element : this.getElements()) {
            labels.add(element.getLabel());
        }
        return labels;
    }

    public T getElementByLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        return (T)((SequenceElement)this.elementsMap.get(label));
    }

    public List<T> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public T getSequenceLabel() {
        return this.label;
    }

    public List<T> getSequenceLabels() {
        return this.labels;
    }

    public void setSequenceLabels(List<T> labels) {
        this.labels = labels;
    }

    public void setSequenceLabel(@NonNull T label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        if (!this.labels.contains(label)) {
            this.labels.add(label);
        }
    }

    public void addSequenceLabel(@NonNull T label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.labels.add(label);
        if (this.label == null) {
            this.label = label;
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    public T getElementByIndex(int index) {
        return (T)((SequenceElement)this.elements.get(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sequence sequence = (Sequence)o;
        return this.elements != null ? this.elements.equals(sequence.elements) : sequence.elements == null;
    }

    public int hashCode() {
        if (this.hashCached) {
            return this.hash;
        }
        for (SequenceElement element : this.elements) {
            this.hash += 31 * element.hashCode();
        }
        this.hashCached = true;
        return this.hash;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }
}

