/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.apache.commons.lang3.RandomUtils;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.BatchItem;
import org.deeplearning4j.models.embeddings.learning.impl.elements.BatchSequences;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.impl.nlp.CbowRound;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.DeviceLocalNDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBOW<T extends SequenceElement>
implements ElementsLearningAlgorithm<T> {
    private VocabCache<T> vocabCache;
    private WeightLookupTable<T> lookupTable;
    private VectorsConfiguration configuration;
    private static final Logger logger = LoggerFactory.getLogger(CBOW.class);
    protected static double MAX_EXP = 6.0;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected int[] variableWindows;
    protected int workers = Runtime.getRuntime().availableProcessors();
    protected DeviceLocalNDArray syn0;
    protected DeviceLocalNDArray syn1;
    protected DeviceLocalNDArray syn1Neg;
    protected DeviceLocalNDArray expTable;
    protected DeviceLocalNDArray table;
    protected ThreadLocal<List<Aggregate>> batches = new ThreadLocal();

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public List<Aggregate> getBatch() {
        return this.batches.get();
    }

    @Override
    public String getCodeName() {
        return "CBOW";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache is marked non-null but is null");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        if (configuration.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() == null) {
            logger.info("Initializing syn1Neg...");
            ((InMemoryLookupTable)lookupTable).setUseHS(configuration.isUseHierarchicSoftmax());
            ((InMemoryLookupTable)lookupTable).setNegative(configuration.getNegative());
            ((InMemoryLookupTable)lookupTable).resetWeights(false);
        }
        this.syn0 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn0());
        this.syn1 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1());
        this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1Neg());
        this.expTable = new DeviceLocalNDArray(Nd4j.create((double[])((InMemoryLookupTable)lookupTable).getExpTable(), (long[])new long[]{((InMemoryLookupTable)lookupTable).getExpTable().length}, (DataType)this.syn0.get().dataType()));
        this.table = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getTable());
        this.variableWindows = configuration.getVariableWindows();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    @Override
    public void finish() {
        if (this.batches != null && this.batches.get() != null && !this.batches.get().isEmpty()) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
    }

    @Override
    public double learnSequence(Sequence<T> sequence, AtomicLong nextRandom, double learningRate, BatchSequences<T> batchSequences) {
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        int currentWindow = this.window;
        if (this.variableWindows != null && this.variableWindows.length != 0) {
            currentWindow = this.variableWindows[RandomUtils.nextInt((int)0, (int)this.variableWindows.length)];
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.cbow(i, tempSequence.getElements(), (int)nextRandom.get() % currentWindow, nextRandom, learningRate, currentWindow, batchSequences);
        }
        return 0.0;
    }

    @Override
    public double learnSequence(Sequence<T> sequence, AtomicLong nextRandom, double learningRate) {
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        int currentWindow = this.window;
        if (this.variableWindows != null && this.variableWindows.length != 0) {
            currentWindow = this.variableWindows[RandomUtils.nextInt((int)0, (int)this.variableWindows.length)];
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.cbow(i, tempSequence.getElements(), (int)nextRandom.get() % currentWindow, nextRandom, learningRate, currentWindow, null);
        }
        return 0.0;
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    public void iterateSample(T currentWord, int[] windowWords, boolean[] wordStatuses, AtomicLong nextRandom, double alpha, boolean isInference, int numLabels, boolean trainWords, INDArray inferenceVector) {
        int[] idxSyn1 = null;
        byte[] codes = null;
        if (this.configuration.isUseHierarchicSoftmax()) {
            idxSyn1 = new int[((SequenceElement)currentWord).getCodeLength()];
            codes = new byte[((SequenceElement)currentWord).getCodeLength()];
            for (int p = 0; p < ((SequenceElement)currentWord).getCodeLength(); ++p) {
                if (((SequenceElement)currentWord).getPoints().get(p) < 0) continue;
                codes[p] = ((SequenceElement)currentWord).getCodes().get(p);
                idxSyn1[p] = ((SequenceElement)currentWord).getPoints().get(p);
            }
        } else {
            idxSyn1 = new int[]{};
            codes = new byte[]{};
        }
        if (this.negative > 0.0 && this.syn1Neg == null) {
            ((InMemoryLookupTable)this.lookupTable).initNegative();
            this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)this.lookupTable).getSyn1Neg());
        }
        if (this.batches.get() == null) {
            this.batches.set(new ArrayList());
        }
        boolean useHS = this.configuration.isUseHierarchicSoftmax();
        boolean useNegative = this.configuration.getNegative() > 0.0;
        int[] inputStatuses = new int[windowWords.length];
        for (int i = 0; i < windowWords.length; ++i) {
            inputStatuses[i] = i < wordStatuses.length ? (wordStatuses[i] ? 1 : 0) : -1;
        }
        INDArray wordsStatuses = Nd4j.createFromArray((int[])inputStatuses);
        CbowRound cbow = null;
        if (useHS && useNegative) {
            cbow = new CbowRound(Nd4j.scalar((int)((SequenceElement)currentWord).getIndex()), Nd4j.createFromArray((int[])windowWords), wordsStatuses, Nd4j.scalar((int)((SequenceElement)currentWord).getIndex()), this.syn0.get(), this.syn1.get(), this.syn1Neg.get(), this.expTable.get(), this.table.get(), Nd4j.createFromArray((int[])idxSyn1), Nd4j.createFromArray((byte[])codes), (int)this.negative, Nd4j.scalar((double)alpha), Nd4j.scalar((long)nextRandom.get()), inferenceVector != null ? inferenceVector : Nd4j.empty((DataType)this.syn0.get().dataType()), Nd4j.empty((DataType)DataType.INT), trainWords, this.workers);
        } else if (useHS) {
            cbow = new CbowRound(((SequenceElement)currentWord).getIndex(), windowWords, wordsStatuses.toIntVector(), this.syn0.get(), this.syn1.get(), this.expTable.get(), idxSyn1, codes, alpha, nextRandom.get(), inferenceVector != null ? inferenceVector : Nd4j.empty((DataType)this.syn0.get().dataType()), 0);
        } else if (useNegative) {
            cbow = new CbowRound(((SequenceElement)currentWord).getIndex(), windowWords, wordsStatuses.toIntVector(), ((SequenceElement)currentWord).getIndex(), this.syn0.get(), this.syn1Neg.get(), this.expTable.get(), this.table.get(), (int)this.negative, alpha, nextRandom.get(), inferenceVector != null ? inferenceVector : Nd4j.empty((DataType)this.syn0.get().dataType()), 0);
        }
        nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
        Nd4j.getExecutioner().exec(cbow);
    }

    public void iterateSample(List<BatchItem<T>> items) {
        boolean useHS = this.configuration.isUseHierarchicSoftmax();
        boolean useNegative = this.configuration.getNegative() > 0.0;
        int[] idxSyn1 = null;
        byte[] codes = null;
        int maxCols = 1;
        for (int i = 0; i < items.size(); ++i) {
            int curr = ((SequenceElement)items.get(i).getWord()).getCodeLength();
            if (curr <= maxCols) continue;
            maxCols = curr;
        }
        byte[][] inputCodes = new byte[items.size()][maxCols];
        int[][] inputIndices = new int[items.size()][maxCols];
        int[] numLabels = new int[items.size()];
        boolean hasNumLabels = false;
        int maxWinWordsCols = -1;
        for (int i = 0; i < items.size(); ++i) {
            int curr = items.get(i).getWindowWords().length;
            if (curr <= maxWinWordsCols) continue;
            maxWinWordsCols = curr;
        }
        int[][] inputWindowWords = new int[items.size()][maxWinWordsCols];
        int[][] inputWordsStatuses = new int[items.size()][maxWinWordsCols];
        long[] randoms = new long[items.size()];
        double[] alphas = new double[items.size()];
        int[] currentWordIndexes = new int[items.size()];
        for (int cnt = 0; cnt < items.size(); ++cnt) {
            double alpha;
            T currentWord = items.get(cnt).getWord();
            currentWordIndexes[cnt] = ((SequenceElement)currentWord).getIndex();
            int[] windowWords = (int[])items.get(cnt).getWindowWords().clone();
            boolean[] windowStatuses = (boolean[])items.get(cnt).getWordStatuses().clone();
            for (int i = 0; i < maxWinWordsCols; ++i) {
                if (i < windowWords.length) {
                    inputWindowWords[cnt][i] = windowWords[i];
                    inputWordsStatuses[cnt][i] = windowStatuses[i] ? 1 : 0;
                    continue;
                }
                inputWindowWords[cnt][i] = -1;
                inputWordsStatuses[cnt][i] = -1;
            }
            long randomValue = items.get(cnt).getRandomValue();
            alphas[cnt] = alpha = items.get(cnt).getAlpha();
            randoms[cnt] = randomValue;
            numLabels[cnt] = items.get(cnt).getNumLabel();
            if (numLabels[cnt] > 0) {
                hasNumLabels = true;
            }
            if (useHS) {
                int i;
                idxSyn1 = new int[((SequenceElement)currentWord).getCodeLength()];
                codes = new byte[((SequenceElement)currentWord).getCodeLength()];
                for (int p = 0; p < ((SequenceElement)currentWord).getCodeLength(); ++p) {
                    if (((SequenceElement)currentWord).getPoints().get(p) < 0) continue;
                    codes[p] = ((SequenceElement)currentWord).getCodes().get(p);
                    idxSyn1[p] = ((SequenceElement)currentWord).getPoints().get(p);
                }
                for (i = 0; i < maxCols; ++i) {
                    inputCodes[cnt][i] = i < ((SequenceElement)currentWord).getCodeLength() ? codes[i] : -1;
                }
                for (i = 0; i < maxCols; ++i) {
                    inputIndices[cnt][i] = i < ((SequenceElement)currentWord).getCodeLength() ? idxSyn1[i] : -1;
                }
            } else {
                idxSyn1 = new int[]{};
                codes = new byte[]{};
                inputIndices = new int[0][0];
                inputCodes = new byte[0][0];
            }
            if (this.negative > 0.0 && this.syn1Neg == null) {
                ((InMemoryLookupTable)this.lookupTable).initNegative();
                this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)this.lookupTable).getSyn1Neg());
            }
            if (this.batches.get() != null) continue;
            this.batches.set(new ArrayList());
        }
        INDArray currentWordIndexesArray = Nd4j.createFromArray((int[])currentWordIndexes);
        INDArray alphasArray = Nd4j.createFromArray((double[])alphas);
        INDArray windowWordsArray = Nd4j.createFromArray((int[][])inputWindowWords);
        INDArray wordsStatusesArray = Nd4j.createFromArray((int[][])inputWordsStatuses);
        INDArray codesArray = Nd4j.createFromArray((byte[][])inputCodes);
        INDArray indicesArray = Nd4j.createFromArray((int[][])inputIndices);
        INDArray numLabelsArray = Nd4j.createFromArray((int[])numLabels);
        CbowRound cbow = new CbowRound(currentWordIndexesArray, windowWordsArray, wordsStatusesArray, currentWordIndexesArray, this.syn0.get(), useHS ? this.syn1.get() : Nd4j.empty((DataType)this.syn0.get().dataType()), this.negative > 0.0 ? this.syn1Neg.get() : Nd4j.empty((DataType)this.syn0.get().dataType()), this.expTable.get(), this.negative > 0.0 ? this.table.get() : Nd4j.empty((DataType)this.syn0.get().dataType()), useHS ? indicesArray : Nd4j.empty((DataType)DataType.INT), useHS ? codesArray : Nd4j.empty((DataType)DataType.BYTE), (int)this.negative, alphasArray, Nd4j.createFromArray((long[])randoms), Nd4j.empty((DataType)this.syn0.get().dataType()), hasNumLabels ? numLabelsArray : Nd4j.empty((DataType)DataType.INT), this.configuration.isTrainElementsVectors(), this.workers);
        Nd4j.getExecutioner().exec((CustomOp)cbow);
    }

    public void cbow(int i, List<T> sentence, int b, AtomicLong nextRandom, double alpha, int currentWindow, BatchSequences<T> batchSequences) {
        int batchSize = this.configuration.getBatchSize();
        int end = this.window * 2 + 1 - b;
        SequenceElement currentWord = (SequenceElement)sentence.get(i);
        ArrayList<Integer> intsList = new ArrayList<Integer>();
        ArrayList<Boolean> statusesList = new ArrayList<Boolean>();
        for (int a = b; a < end; ++a) {
            int c;
            if (a == currentWindow || (c = i - currentWindow + a) < 0 || c >= sentence.size()) continue;
            SequenceElement lastWord = (SequenceElement)sentence.get(c);
            intsList.add(lastWord.getIndex());
            statusesList.add(lastWord.isLocked());
        }
        int[] windowWords = new int[intsList.size()];
        boolean[] statuses = new boolean[intsList.size()];
        for (int x = 0; x < windowWords.length; ++x) {
            windowWords[x] = (Integer)intsList.get(x);
            statuses[x] = (Boolean)statusesList.get(x);
        }
        if (batchSize <= 1) {
            this.iterateSample(currentWord, windowWords, statuses, nextRandom, alpha, false, 0, true, null);
        } else {
            batchSequences.put(currentWord, windowWords, statuses, nextRandom.get(), alpha);
        }
        if (this.batches != null && this.batches.get() != null && this.batches.get().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
    }

    public Sequence<T> applySubsampling(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom) {
        if (sequence == null) {
            throw new NullPointerException("sequence is marked non-null but is null");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom is marked non-null but is null");
        }
        Sequence<T> result = new Sequence<T>();
        if (this.sampling > 0.0) {
            result.setSequenceId(sequence.getSequenceId());
            if (sequence.getSequenceLabels() != null) {
                result.setSequenceLabels(sequence.getSequenceLabels());
            }
            if (sequence.getSequenceLabel() != null) {
                result.setSequenceLabel(sequence.getSequenceLabel());
            }
            for (SequenceElement element : sequence.getElements()) {
                double numWords = this.vocabCache.totalWordOccurrences();
                double ran = (Math.sqrt(element.getElementFrequency() / (this.sampling * numWords)) + 1.0) * (this.sampling * numWords) / element.getElementFrequency();
                nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                result.addElement(element);
            }
            return result;
        }
        return sequence;
    }

    public DeviceLocalNDArray getSyn0() {
        return this.syn0;
    }

    public DeviceLocalNDArray getSyn1() {
        return this.syn1;
    }

    public DeviceLocalNDArray getSyn1Neg() {
        return this.syn1Neg;
    }

    public DeviceLocalNDArray getExpTable() {
        return this.expTable;
    }

    public DeviceLocalNDArray getTable() {
        return this.table;
    }

    public void setSyn0(DeviceLocalNDArray syn0) {
        this.syn0 = syn0;
    }

    public void setSyn1(DeviceLocalNDArray syn1) {
        this.syn1 = syn1;
    }

    public void setSyn1Neg(DeviceLocalNDArray syn1Neg) {
        this.syn1Neg = syn1Neg;
    }

    public void setExpTable(DeviceLocalNDArray expTable) {
        this.expTable = expTable;
    }

    public void setTable(DeviceLocalNDArray table) {
        this.table = table;
    }
}

