/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class AggregatingSentenceIterator
implements SentenceIterator {
    private List<SentenceIterator> backendIterators;
    private SentencePreProcessor preProcessor;
    private AtomicInteger position = new AtomicInteger(0);

    private AggregatingSentenceIterator(@NonNull List<SentenceIterator> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.backendIterators = list;
    }

    @Override
    public String nextSentence() {
        if (!this.backendIterators.get(this.position.get()).hasNext() && this.position.get() < this.backendIterators.size()) {
            this.position.incrementAndGet();
        }
        return this.preProcessor == null ? this.backendIterators.get(this.position.get()).nextSentence() : this.preProcessor.preProcess(this.backendIterators.get(this.position.get()).nextSentence());
    }

    @Override
    public boolean hasNext() {
        for (SentenceIterator iterator : this.backendIterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        for (SentenceIterator iterator : this.backendIterators) {
            iterator.reset();
        }
        this.position.set(0);
    }

    @Override
    public void finish() {
        for (SentenceIterator iterator : this.backendIterators) {
            iterator.finish();
        }
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public static class Builder {
        private List<SentenceIterator> backendIterators = new ArrayList<SentenceIterator>();
        private SentencePreProcessor preProcessor;

        public Builder addSentenceIterator(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.backendIterators.add(iterator);
            return this;
        }

        public Builder addSentenceIterators(@NonNull Collection<SentenceIterator> iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.backendIterators.addAll(iterator);
            return this;
        }

        @Deprecated
        public Builder addSentencePreProcessor(@NonNull SentencePreProcessor preProcessor) {
            if (preProcessor == null) {
                throw new NullPointerException("preProcessor is marked non-null but is null");
            }
            return this.sentencePreProcessor(preProcessor);
        }

        public Builder sentencePreProcessor(@NonNull SentencePreProcessor preProcessor) {
            if (preProcessor == null) {
                throw new NullPointerException("preProcessor is marked non-null but is null");
            }
            this.preProcessor = preProcessor;
            return this;
        }

        public AggregatingSentenceIterator build() {
            AggregatingSentenceIterator sentenceIterator = new AggregatingSentenceIterator(this.backendIterators);
            if (this.preProcessor != null) {
                sentenceIterator.setPreProcessor(this.preProcessor);
            }
            return sentenceIterator;
        }
    }
}

