/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.fasttext;

import com.github.jfasttext.JFastText;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastText
implements WordVectors,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(FastText.class);
    private static final String METHOD_NOT_AVAILABLE = "This method is available for text (.vec) models only - binary (.bin) model currently loaded";
    private String inputFile;
    private String outputFile;
    private int bucket;
    private int minCount;
    private int minCountLabel;
    private int wordNgrams;
    private int minNgramLength;
    private int maxNgramLength;
    private int samplingThreshold;
    private String labelPrefix;
    private boolean supervised;
    private boolean quantize;
    private boolean predict;
    private boolean predict_prob;
    private boolean skipgram;
    private boolean cbow;
    private boolean nn;
    private boolean analogies;
    private String pretrainedVectorsFile;
    private double learningRate;
    private double learningRateUpdate = -1.0;
    private int dim;
    private int contextWindowSize;
    private int epochs;
    private String modelName;
    private String lossName;
    private int negativeSamples;
    private int numThreads;
    private boolean saveOutput = false;
    private int cutOff;
    private boolean retrain;
    private boolean qnorm;
    private boolean qout;
    private int dsub;
    private SentenceIterator iterator;
    private transient JFastText fastTextImpl;
    private transient Word2Vec word2Vec;
    private boolean modelLoaded;
    private boolean modelVectorsLoaded;
    private VocabCache vocabCache;
    private List<String> words = new ArrayList<String>();

    public FastText(File modelPath) {
        this();
        this.loadBinaryModel(modelPath.getAbsolutePath());
    }

    public FastText() {
        this.fastTextImpl = new JFastText();
    }

    private String[] makeArgs() {
        ArgsFactory argsFactory = new ArgsFactory();
        argsFactory.addOptional("cbow", this.cbow);
        argsFactory.addOptional("skipgram", this.skipgram);
        argsFactory.addOptional("supervised", this.supervised);
        argsFactory.addOptional("quantize", this.quantize);
        argsFactory.addOptional("predict", this.predict);
        argsFactory.addOptional("predict_prob", this.predict_prob);
        argsFactory.add("-input", this.inputFile);
        argsFactory.add("-output", this.outputFile);
        argsFactory.addOptional("-pretrainedVectors", this.pretrainedVectorsFile);
        argsFactory.addOptional("-bucket", this.bucket);
        argsFactory.addOptional("-minCount", this.minCount);
        argsFactory.addOptional("-minCountLabel", this.minCountLabel);
        argsFactory.addOptional("-wordNgrams", this.wordNgrams);
        argsFactory.addOptional("-minn", this.minNgramLength);
        argsFactory.addOptional("-maxn", this.maxNgramLength);
        argsFactory.addOptional("-t", this.samplingThreshold);
        argsFactory.addOptional("-label", this.labelPrefix);
        argsFactory.addOptional("analogies", this.analogies);
        argsFactory.addOptional("-lr", this.learningRate);
        argsFactory.addOptional("-lrUpdateRate", this.learningRateUpdate);
        argsFactory.addOptional("-dim", this.dim);
        argsFactory.addOptional("-ws", this.contextWindowSize);
        argsFactory.addOptional("-epoch", this.epochs);
        argsFactory.addOptional("-loss", this.lossName);
        argsFactory.addOptional("-neg", this.negativeSamples);
        argsFactory.addOptional("-thread", this.numThreads);
        argsFactory.addOptional("-saveOutput", this.saveOutput);
        argsFactory.addOptional("-cutoff", this.cutOff);
        argsFactory.addOptional("-retrain", this.retrain);
        argsFactory.addOptional("-qnorm", this.qnorm);
        argsFactory.addOptional("-qout", this.qout);
        argsFactory.addOptional("-dsub", this.dsub);
        return argsFactory.args();
    }

    public void fit() {
        String[] cmd = this.makeArgs();
        this.fastTextImpl.runCmd(cmd);
    }

    public void loadIterator() {
        if (this.iterator != null) {
            try {
                File tempFile = File.createTempFile("FTX", ".txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
                while (this.iterator.hasNext()) {
                    String sentence = this.iterator.nextSentence();
                    writer.write(sentence);
                }
                this.fastTextImpl = new JFastText();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    public void loadPretrainedVectors(File vectorsFile) {
        this.word2Vec = WordVectorSerializer.readWord2VecModel(vectorsFile);
        this.modelVectorsLoaded = true;
        log.info("Loaded vectorized representation from file %s. Functionality will be restricted.", (Object)vectorsFile.getAbsolutePath());
    }

    public void loadBinaryModel(String modelPath) {
        this.fastTextImpl.loadModel(modelPath);
        this.modelLoaded = true;
    }

    public void unloadBinaryModel() {
        this.fastTextImpl.unloadModel();
        this.modelLoaded = false;
    }

    public void test(File testFile) {
        this.fastTextImpl.test(testFile.getAbsolutePath());
    }

    private void assertModelLoaded() {
        if (!this.modelLoaded && !this.modelVectorsLoaded) {
            throw new IllegalStateException("Model must be loaded before predict!");
        }
    }

    public String predict(String text) {
        this.assertModelLoaded();
        String label = this.fastTextImpl.predict(text);
        return label;
    }

    public Pair<String, Float> predictProbability(String text) {
        this.assertModelLoaded();
        JFastText.ProbLabel predictedProbLabel = this.fastTextImpl.predictProba(text);
        Pair retVal = new Pair();
        retVal.setFirst((Object)predictedProbLabel.label);
        retVal.setSecond((Object)Float.valueOf(predictedProbLabel.logProb));
        return retVal;
    }

    @Override
    public VocabCache vocab() {
        if (this.modelVectorsLoaded) {
            this.vocabCache = this.word2Vec.vocab();
        } else {
            if (!this.modelLoaded) {
                throw new IllegalStateException("Load model before calling vocab()");
            }
            if (this.vocabCache == null) {
                this.vocabCache = new AbstractCache();
            }
            List words = this.fastTextImpl.getWords();
            for (int i = 0; i < words.size(); ++i) {
                this.vocabCache.addWordToIndex(i, (String)words.get(i));
                VocabWord word = new VocabWord();
                word.setWord((String)words.get(i));
                this.vocabCache.addToken(word);
            }
        }
        return this.vocabCache;
    }

    public long vocabSize() {
        long result = 0L;
        if (this.modelVectorsLoaded) {
            result = this.word2Vec.vocabSize();
        } else {
            if (!this.modelLoaded) {
                throw new IllegalStateException("Load model before calling vocab()");
            }
            result = this.fastTextImpl.getNWords();
        }
        return result;
    }

    @Override
    public String getUNK() {
        throw new NotImplementedException("FastText.getUNK");
    }

    @Override
    public void setUNK(String input) {
        throw new NotImplementedException("FastText.setUNK");
    }

    @Override
    public double[] getWordVector(String word) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.getWordVector(word);
        }
        List vectors = this.fastTextImpl.getVector(word);
        double[] retVal = new double[vectors.size()];
        for (int i = 0; i < vectors.size(); ++i) {
            retVal[i] = ((Float)vectors.get(i)).floatValue();
        }
        return retVal;
    }

    @Override
    public INDArray getWordVectorMatrixNormalized(String word) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.getWordVectorMatrixNormalized(word);
        }
        INDArray r = this.getWordVectorMatrix(word);
        return r.divi((Number)Nd4j.getBlasWrapper().nrm2(r));
    }

    @Override
    public INDArray getWordVectorMatrix(String word) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.getWordVectorMatrix(word);
        }
        double[] values = this.getWordVector(word);
        return Nd4j.createFromArray((double[])values);
    }

    @Override
    public INDArray getWordVectors(Collection<String> labels) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.getWordVectors(labels);
        }
        return null;
    }

    @Override
    public INDArray getWordVectorsMean(Collection<String> labels) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.getWordVectorsMean(labels);
        }
        return null;
    }

    @Override
    public boolean hasWord(String word) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.outOfVocabularySupported();
        }
        if (this.words.isEmpty()) {
            this.words = this.fastTextImpl.getWords();
        }
        return this.words.contains(word);
    }

    @Override
    public Collection<String> wordsNearest(INDArray words, int top) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearest(words, top);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Collection<String> wordsNearestSum(INDArray words, int top) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearestSum(words, top);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Collection<String> wordsNearestSum(String word, int n) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearestSum(word, n);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Collection<String> wordsNearestSum(Collection<String> positive, Collection<String> negative, int top) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearestSum(positive, negative, top);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Map<String, Double> accuracy(List<String> questions) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.accuracy(questions);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public int indexOf(String word) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.indexOf(word);
        }
        return this.vocab().indexOf(word);
    }

    @Override
    public List<String> similarWordsInVocabTo(String word, double accuracy) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.similarWordsInVocabTo(word, accuracy);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Collection<String> wordsNearest(Collection<String> positive, Collection<String> negative, int top) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearest(positive, negative, top);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public Collection<String> wordsNearest(String word, int n) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.wordsNearest(word, n);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public double similarity(String word, String word2) {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.similarity(word, word2);
        }
        throw new IllegalStateException(METHOD_NOT_AVAILABLE);
    }

    @Override
    public WeightLookupTable lookupTable() {
        if (this.modelVectorsLoaded) {
            return this.word2Vec.lookupTable();
        }
        return null;
    }

    @Override
    public void setModelUtils(ModelUtils utils) {
    }

    public void loadWeightsInto(INDArray array) {
    }

    public int vectorSize() {
        return -1;
    }

    public boolean jsonSerializable() {
        return false;
    }

    public double getLearningRate() {
        return this.fastTextImpl.getLr();
    }

    public int getDimension() {
        return this.fastTextImpl.getDim();
    }

    public int getContextWindowSize() {
        return this.fastTextImpl.getContextWindowSize();
    }

    public int getEpoch() {
        return this.fastTextImpl.getEpoch();
    }

    public int getNegativesNumber() {
        return this.fastTextImpl.getNSampledNegatives();
    }

    public int getWordNgrams() {
        return this.fastTextImpl.getWordNgrams();
    }

    public String getLossName() {
        return this.fastTextImpl.getLossName();
    }

    public String getModelName() {
        return this.fastTextImpl.getModelName();
    }

    public int getNumberOfBuckets() {
        return this.fastTextImpl.getBucket();
    }

    public String getLabelPrefix() {
        return this.fastTextImpl.getLabelPrefix();
    }

    @Override
    public boolean outOfVocabularySupported() {
        return true;
    }

    private static int $default$bucket() {
        return -1;
    }

    private static int $default$minCount() {
        return -1;
    }

    private static int $default$minCountLabel() {
        return -1;
    }

    private static int $default$wordNgrams() {
        return -1;
    }

    private static int $default$minNgramLength() {
        return -1;
    }

    private static int $default$maxNgramLength() {
        return -1;
    }

    private static int $default$samplingThreshold() {
        return -1;
    }

    private static double $default$learningRate() {
        return -1.0;
    }

    private static int $default$dim() {
        return -1;
    }

    private static int $default$contextWindowSize() {
        return -1;
    }

    private static int $default$epochs() {
        return -1;
    }

    private static int $default$negativeSamples() {
        return -1;
    }

    private static int $default$numThreads() {
        return -1;
    }

    private static int $default$cutOff() {
        return -1;
    }

    private static int $default$dsub() {
        return -1;
    }

    private static JFastText $default$fastTextImpl() {
        return new JFastText();
    }

    public static FastTextBuilder builder() {
        return new FastTextBuilder();
    }

    public FastText(String inputFile, String outputFile, int bucket, int minCount, int minCountLabel, int wordNgrams, int minNgramLength, int maxNgramLength, int samplingThreshold, String labelPrefix, boolean supervised, boolean quantize, boolean predict, boolean predict_prob, boolean skipgram, boolean cbow, boolean nn, boolean analogies, String pretrainedVectorsFile, double learningRate, double learningRateUpdate, int dim, int contextWindowSize, int epochs, String modelName, String lossName, int negativeSamples, int numThreads, boolean saveOutput, int cutOff, boolean retrain, boolean qnorm, boolean qout, int dsub, SentenceIterator iterator, JFastText fastTextImpl, Word2Vec word2Vec, boolean modelLoaded, boolean modelVectorsLoaded, VocabCache vocabCache, List<String> words) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.bucket = bucket;
        this.minCount = minCount;
        this.minCountLabel = minCountLabel;
        this.wordNgrams = wordNgrams;
        this.minNgramLength = minNgramLength;
        this.maxNgramLength = maxNgramLength;
        this.samplingThreshold = samplingThreshold;
        this.labelPrefix = labelPrefix;
        this.supervised = supervised;
        this.quantize = quantize;
        this.predict = predict;
        this.predict_prob = predict_prob;
        this.skipgram = skipgram;
        this.cbow = cbow;
        this.nn = nn;
        this.analogies = analogies;
        this.pretrainedVectorsFile = pretrainedVectorsFile;
        this.learningRate = learningRate;
        this.learningRateUpdate = learningRateUpdate;
        this.dim = dim;
        this.contextWindowSize = contextWindowSize;
        this.epochs = epochs;
        this.modelName = modelName;
        this.lossName = lossName;
        this.negativeSamples = negativeSamples;
        this.numThreads = numThreads;
        this.saveOutput = saveOutput;
        this.cutOff = cutOff;
        this.retrain = retrain;
        this.qnorm = qnorm;
        this.qout = qout;
        this.dsub = dsub;
        this.iterator = iterator;
        this.fastTextImpl = fastTextImpl;
        this.word2Vec = word2Vec;
        this.modelLoaded = modelLoaded;
        this.modelVectorsLoaded = modelVectorsLoaded;
        this.vocabCache = vocabCache;
        this.words = words;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean isSupervised() {
        return this.supervised;
    }

    public boolean isQuantize() {
        return this.quantize;
    }

    public boolean isPredict() {
        return this.predict;
    }

    public boolean isPredict_prob() {
        return this.predict_prob;
    }

    public boolean isSkipgram() {
        return this.skipgram;
    }

    public boolean isCbow() {
        return this.cbow;
    }

    public boolean isNn() {
        return this.nn;
    }

    public boolean isAnalogies() {
        return this.analogies;
    }

    public String getPretrainedVectorsFile() {
        return this.pretrainedVectorsFile;
    }

    public double getLearningRateUpdate() {
        return this.learningRateUpdate;
    }

    public int getDim() {
        return this.dim;
    }

    public int getEpochs() {
        return this.epochs;
    }

    public int getNegativeSamples() {
        return this.negativeSamples;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public boolean isSaveOutput() {
        return this.saveOutput;
    }

    public int getCutOff() {
        return this.cutOff;
    }

    public boolean isRetrain() {
        return this.retrain;
    }

    public boolean isQnorm() {
        return this.qnorm;
    }

    public boolean isQout() {
        return this.qout;
    }

    public int getDsub() {
        return this.dsub;
    }

    public SentenceIterator getIterator() {
        return this.iterator;
    }

    public boolean isModelLoaded() {
        return this.modelLoaded;
    }

    public boolean isModelVectorsLoaded() {
        return this.modelVectorsLoaded;
    }

    public static class FastTextBuilder {
        private String inputFile;
        private String outputFile;
        private boolean bucket$set;
        private int bucket$value;
        private boolean minCount$set;
        private int minCount$value;
        private boolean minCountLabel$set;
        private int minCountLabel$value;
        private boolean wordNgrams$set;
        private int wordNgrams$value;
        private boolean minNgramLength$set;
        private int minNgramLength$value;
        private boolean maxNgramLength$set;
        private int maxNgramLength$value;
        private boolean samplingThreshold$set;
        private int samplingThreshold$value;
        private String labelPrefix;
        private boolean supervised;
        private boolean quantize;
        private boolean predict;
        private boolean predict_prob;
        private boolean skipgram;
        private boolean cbow;
        private boolean nn;
        private boolean analogies;
        private String pretrainedVectorsFile;
        private boolean learningRate$set;
        private double learningRate$value;
        private double learningRateUpdate;
        private boolean dim$set;
        private int dim$value;
        private boolean contextWindowSize$set;
        private int contextWindowSize$value;
        private boolean epochs$set;
        private int epochs$value;
        private String modelName;
        private String lossName;
        private boolean negativeSamples$set;
        private int negativeSamples$value;
        private boolean numThreads$set;
        private int numThreads$value;
        private boolean saveOutput;
        private boolean cutOff$set;
        private int cutOff$value;
        private boolean retrain;
        private boolean qnorm;
        private boolean qout;
        private boolean dsub$set;
        private int dsub$value;
        private SentenceIterator iterator;
        private boolean fastTextImpl$set;
        private JFastText fastTextImpl$value;
        private Word2Vec word2Vec;
        private boolean modelLoaded;
        private boolean modelVectorsLoaded;
        private VocabCache vocabCache;
        private List<String> words;

        FastTextBuilder() {
        }

        public FastTextBuilder inputFile(String inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public FastTextBuilder outputFile(String outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public FastTextBuilder bucket(int bucket) {
            this.bucket$value = bucket;
            this.bucket$set = true;
            return this;
        }

        public FastTextBuilder minCount(int minCount) {
            this.minCount$value = minCount;
            this.minCount$set = true;
            return this;
        }

        public FastTextBuilder minCountLabel(int minCountLabel) {
            this.minCountLabel$value = minCountLabel;
            this.minCountLabel$set = true;
            return this;
        }

        public FastTextBuilder wordNgrams(int wordNgrams) {
            this.wordNgrams$value = wordNgrams;
            this.wordNgrams$set = true;
            return this;
        }

        public FastTextBuilder minNgramLength(int minNgramLength) {
            this.minNgramLength$value = minNgramLength;
            this.minNgramLength$set = true;
            return this;
        }

        public FastTextBuilder maxNgramLength(int maxNgramLength) {
            this.maxNgramLength$value = maxNgramLength;
            this.maxNgramLength$set = true;
            return this;
        }

        public FastTextBuilder samplingThreshold(int samplingThreshold) {
            this.samplingThreshold$value = samplingThreshold;
            this.samplingThreshold$set = true;
            return this;
        }

        public FastTextBuilder labelPrefix(String labelPrefix) {
            this.labelPrefix = labelPrefix;
            return this;
        }

        public FastTextBuilder supervised(boolean supervised) {
            this.supervised = supervised;
            return this;
        }

        public FastTextBuilder quantize(boolean quantize) {
            this.quantize = quantize;
            return this;
        }

        public FastTextBuilder predict(boolean predict) {
            this.predict = predict;
            return this;
        }

        public FastTextBuilder predict_prob(boolean predict_prob) {
            this.predict_prob = predict_prob;
            return this;
        }

        public FastTextBuilder skipgram(boolean skipgram) {
            this.skipgram = skipgram;
            return this;
        }

        public FastTextBuilder cbow(boolean cbow) {
            this.cbow = cbow;
            return this;
        }

        public FastTextBuilder nn(boolean nn) {
            this.nn = nn;
            return this;
        }

        public FastTextBuilder analogies(boolean analogies) {
            this.analogies = analogies;
            return this;
        }

        public FastTextBuilder pretrainedVectorsFile(String pretrainedVectorsFile) {
            this.pretrainedVectorsFile = pretrainedVectorsFile;
            return this;
        }

        public FastTextBuilder learningRate(double learningRate) {
            this.learningRate$value = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public FastTextBuilder learningRateUpdate(double learningRateUpdate) {
            this.learningRateUpdate = learningRateUpdate;
            return this;
        }

        public FastTextBuilder dim(int dim) {
            this.dim$value = dim;
            this.dim$set = true;
            return this;
        }

        public FastTextBuilder contextWindowSize(int contextWindowSize) {
            this.contextWindowSize$value = contextWindowSize;
            this.contextWindowSize$set = true;
            return this;
        }

        public FastTextBuilder epochs(int epochs) {
            this.epochs$value = epochs;
            this.epochs$set = true;
            return this;
        }

        public FastTextBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public FastTextBuilder lossName(String lossName) {
            this.lossName = lossName;
            return this;
        }

        public FastTextBuilder negativeSamples(int negativeSamples) {
            this.negativeSamples$value = negativeSamples;
            this.negativeSamples$set = true;
            return this;
        }

        public FastTextBuilder numThreads(int numThreads) {
            this.numThreads$value = numThreads;
            this.numThreads$set = true;
            return this;
        }

        public FastTextBuilder saveOutput(boolean saveOutput) {
            this.saveOutput = saveOutput;
            return this;
        }

        public FastTextBuilder cutOff(int cutOff) {
            this.cutOff$value = cutOff;
            this.cutOff$set = true;
            return this;
        }

        public FastTextBuilder retrain(boolean retrain) {
            this.retrain = retrain;
            return this;
        }

        public FastTextBuilder qnorm(boolean qnorm) {
            this.qnorm = qnorm;
            return this;
        }

        public FastTextBuilder qout(boolean qout) {
            this.qout = qout;
            return this;
        }

        public FastTextBuilder dsub(int dsub) {
            this.dsub$value = dsub;
            this.dsub$set = true;
            return this;
        }

        public FastTextBuilder iterator(SentenceIterator iterator) {
            this.iterator = iterator;
            return this;
        }

        public FastTextBuilder fastTextImpl(JFastText fastTextImpl) {
            this.fastTextImpl$value = fastTextImpl;
            this.fastTextImpl$set = true;
            return this;
        }

        public FastTextBuilder word2Vec(Word2Vec word2Vec) {
            this.word2Vec = word2Vec;
            return this;
        }

        public FastTextBuilder modelLoaded(boolean modelLoaded) {
            this.modelLoaded = modelLoaded;
            return this;
        }

        public FastTextBuilder modelVectorsLoaded(boolean modelVectorsLoaded) {
            this.modelVectorsLoaded = modelVectorsLoaded;
            return this;
        }

        public FastTextBuilder vocabCache(VocabCache vocabCache) {
            this.vocabCache = vocabCache;
            return this;
        }

        public FastTextBuilder words(List<String> words) {
            this.words = words;
            return this;
        }

        public FastText build() {
            int bucket$value = this.bucket$value;
            if (!this.bucket$set) {
                bucket$value = FastText.$default$bucket();
            }
            int minCount$value = this.minCount$value;
            if (!this.minCount$set) {
                minCount$value = FastText.$default$minCount();
            }
            int minCountLabel$value = this.minCountLabel$value;
            if (!this.minCountLabel$set) {
                minCountLabel$value = FastText.$default$minCountLabel();
            }
            int wordNgrams$value = this.wordNgrams$value;
            if (!this.wordNgrams$set) {
                wordNgrams$value = FastText.$default$wordNgrams();
            }
            int minNgramLength$value = this.minNgramLength$value;
            if (!this.minNgramLength$set) {
                minNgramLength$value = FastText.$default$minNgramLength();
            }
            int maxNgramLength$value = this.maxNgramLength$value;
            if (!this.maxNgramLength$set) {
                maxNgramLength$value = FastText.$default$maxNgramLength();
            }
            int samplingThreshold$value = this.samplingThreshold$value;
            if (!this.samplingThreshold$set) {
                samplingThreshold$value = FastText.$default$samplingThreshold();
            }
            double learningRate$value = this.learningRate$value;
            if (!this.learningRate$set) {
                learningRate$value = FastText.$default$learningRate();
            }
            int dim$value = this.dim$value;
            if (!this.dim$set) {
                dim$value = FastText.$default$dim();
            }
            int contextWindowSize$value = this.contextWindowSize$value;
            if (!this.contextWindowSize$set) {
                contextWindowSize$value = FastText.$default$contextWindowSize();
            }
            int epochs$value = this.epochs$value;
            if (!this.epochs$set) {
                epochs$value = FastText.$default$epochs();
            }
            int negativeSamples$value = this.negativeSamples$value;
            if (!this.negativeSamples$set) {
                negativeSamples$value = FastText.$default$negativeSamples();
            }
            int numThreads$value = this.numThreads$value;
            if (!this.numThreads$set) {
                numThreads$value = FastText.$default$numThreads();
            }
            int cutOff$value = this.cutOff$value;
            if (!this.cutOff$set) {
                cutOff$value = FastText.$default$cutOff();
            }
            int dsub$value = this.dsub$value;
            if (!this.dsub$set) {
                dsub$value = FastText.$default$dsub();
            }
            JFastText fastTextImpl$value = this.fastTextImpl$value;
            if (!this.fastTextImpl$set) {
                fastTextImpl$value = FastText.$default$fastTextImpl();
            }
            return new FastText(this.inputFile, this.outputFile, bucket$value, minCount$value, minCountLabel$value, wordNgrams$value, minNgramLength$value, maxNgramLength$value, samplingThreshold$value, this.labelPrefix, this.supervised, this.quantize, this.predict, this.predict_prob, this.skipgram, this.cbow, this.nn, this.analogies, this.pretrainedVectorsFile, learningRate$value, this.learningRateUpdate, dim$value, contextWindowSize$value, epochs$value, this.modelName, this.lossName, negativeSamples$value, numThreads$value, this.saveOutput, cutOff$value, this.retrain, this.qnorm, this.qout, dsub$value, this.iterator, fastTextImpl$value, this.word2Vec, this.modelLoaded, this.modelVectorsLoaded, this.vocabCache, this.words);
        }

        public String toString() {
            return "FastText.FastTextBuilder(inputFile=" + this.inputFile + ", outputFile=" + this.outputFile + ", bucket$value=" + this.bucket$value + ", minCount$value=" + this.minCount$value + ", minCountLabel$value=" + this.minCountLabel$value + ", wordNgrams$value=" + this.wordNgrams$value + ", minNgramLength$value=" + this.minNgramLength$value + ", maxNgramLength$value=" + this.maxNgramLength$value + ", samplingThreshold$value=" + this.samplingThreshold$value + ", labelPrefix=" + this.labelPrefix + ", supervised=" + this.supervised + ", quantize=" + this.quantize + ", predict=" + this.predict + ", predict_prob=" + this.predict_prob + ", skipgram=" + this.skipgram + ", cbow=" + this.cbow + ", nn=" + this.nn + ", analogies=" + this.analogies + ", pretrainedVectorsFile=" + this.pretrainedVectorsFile + ", learningRate$value=" + this.learningRate$value + ", learningRateUpdate=" + this.learningRateUpdate + ", dim$value=" + this.dim$value + ", contextWindowSize$value=" + this.contextWindowSize$value + ", epochs$value=" + this.epochs$value + ", modelName=" + this.modelName + ", lossName=" + this.lossName + ", negativeSamples$value=" + this.negativeSamples$value + ", numThreads$value=" + this.numThreads$value + ", saveOutput=" + this.saveOutput + ", cutOff$value=" + this.cutOff$value + ", retrain=" + this.retrain + ", qnorm=" + this.qnorm + ", qout=" + this.qout + ", dsub$value=" + this.dsub$value + ", iterator=" + this.iterator + ", fastTextImpl$value=" + this.fastTextImpl$value + ", word2Vec=" + this.word2Vec + ", modelLoaded=" + this.modelLoaded + ", modelVectorsLoaded=" + this.modelVectorsLoaded + ", vocabCache=" + this.vocabCache + ", words=" + this.words + ")";
        }
    }

    private static class ArgsFactory {
        private List<String> args = new ArrayList<String>();

        private ArgsFactory() {
        }

        private void add(String label, String value) {
            this.args.add(label);
            this.args.add(value);
        }

        private void addOptional(String label, int value) {
            if (value >= 0) {
                this.args.add(label);
                this.args.add(Integer.toString(value));
            }
        }

        private void addOptional(String label, double value) {
            if (value >= 0.0) {
                this.args.add(label);
                this.args.add(Double.toString(value));
            }
        }

        private void addOptional(String label, String value) {
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                this.args.add(label);
                this.args.add(value);
            }
        }

        private void addOptional(String label, boolean value) {
            if (value) {
                this.args.add(label);
            }
        }

        public String[] args() {
            String[] asArray = new String[this.args.size()];
            return this.args.toArray(asArray);
        }
    }
}

