/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.transformers.impl;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.graph.primitives.IGraph;
import org.deeplearning4j.models.sequencevectors.graph.walkers.GraphWalker;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.Huffman;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.labels.LabelsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTransformer<T extends SequenceElement>
implements Iterable<Sequence<T>> {
    protected IGraph<T, ?> sourceGraph;
    protected GraphWalker<T> walker;
    protected LabelsProvider<T> labelsProvider;
    protected AtomicInteger counter = new AtomicInteger(0);
    protected boolean shuffle = true;
    protected VocabCache<T> vocabCache;
    protected static final Logger log = LoggerFactory.getLogger(GraphTransformer.class);

    protected GraphTransformer() {
    }

    protected void initialize() {
        log.info("Building Huffman tree for source graph...");
        int nVertices = this.sourceGraph.numVertices();
        log.info("Transferring Huffman tree info to nodes...");
        for (int i = 0; i < nVertices; ++i) {
            T element = this.sourceGraph.getVertex(i).getValue();
            ((SequenceElement)element).setElementFrequency(this.sourceGraph.getConnectedVertices(i).size());
            if (this.vocabCache == null) continue;
            this.vocabCache.addToken(element);
        }
        if (this.vocabCache != null) {
            Huffman huffman = new Huffman(this.vocabCache.vocabWords());
            huffman.build();
            huffman.applyIndexes(this.vocabCache);
        }
    }

    @Override
    public Iterator<Sequence<T>> iterator() {
        this.counter.set(0);
        this.walker.reset(this.shuffle);
        return new Iterator<Sequence<T>>(){
            private GraphWalker<T> walker;
            {
                this.walker = GraphTransformer.this.walker;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This is not supported on read-only iterator");
            }

            @Override
            public boolean hasNext() {
                return this.walker.hasNext();
            }

            @Override
            public Sequence<T> next() {
                Sequence sequence = this.walker.next();
                sequence.setSequenceId(GraphTransformer.this.counter.getAndIncrement());
                if (this.walker.isLabelEnabled() && sequence.getSequenceLabels() == null && GraphTransformer.this.labelsProvider != null) {
                    sequence.setSequenceLabel(GraphTransformer.this.labelsProvider.getLabel(sequence.getSequenceId()));
                }
                return sequence;
            }
        };
    }

    public static class Builder<T extends SequenceElement> {
        protected IGraph<T, ?> sourceGraph;
        protected LabelsProvider<T> labelsProvider;
        protected GraphWalker<T> walker;
        protected boolean shuffle = true;
        protected VocabCache<T> vocabCache;

        public Builder() {
        }

        public Builder(@NonNull GraphWalker<T> walker) {
            if (walker == null) {
                throw new NullPointerException("walker is marked non-null but is null");
            }
            this.walker = walker;
        }

        public Builder(@NonNull IGraph<T, ?> sourceGraph) {
            if (sourceGraph == null) {
                throw new NullPointerException("sourceGraph is marked non-null but is null");
            }
            this.sourceGraph = sourceGraph;
        }

        public Builder<T> setLabelsProvider(@NonNull LabelsProvider<T> provider) {
            if (provider == null) {
                throw new NullPointerException("provider is marked non-null but is null");
            }
            this.labelsProvider = provider;
            return this;
        }

        public Builder<T> setGraphWalker(@NonNull GraphWalker<T> walker) {
            if (walker == null) {
                throw new NullPointerException("walker is marked non-null but is null");
            }
            this.walker = walker;
            return this;
        }

        public Builder<T> setVocabCache(@NonNull VocabCache<T> vocabCache) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache is marked non-null but is null");
            }
            this.vocabCache = vocabCache;
            return this;
        }

        public Builder<T> shuffleOnReset(boolean reallyShuffle) {
            this.shuffle = reallyShuffle;
            return this;
        }

        public GraphTransformer<T> build() {
            if (this.walker == null) {
                throw new IllegalStateException("Please provide GraphWalker instance.");
            }
            GraphTransformer transformer = new GraphTransformer();
            if (this.sourceGraph == null) {
                this.sourceGraph = this.walker.getSourceGraph();
            }
            transformer.sourceGraph = this.sourceGraph;
            transformer.labelsProvider = this.labelsProvider;
            transformer.shuffle = this.shuffle;
            transformer.vocabCache = this.vocabCache;
            transformer.walker = this.walker;
            transformer.initialize();
            return transformer;
        }
    }
}

