/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.util.Iterator;
import lombok.NonNull;
import org.deeplearning4j.parallelism.AsyncIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class AsyncLabelAwareIterator
implements LabelAwareIterator,
Iterator<LabelledDocument> {
    protected LabelAwareIterator backedIterator;
    protected AsyncIterator<LabelledDocument> asyncIterator;
    protected int bufferSize;

    public AsyncLabelAwareIterator(@NonNull LabelAwareIterator iterator, int bufferSize) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.backedIterator = iterator;
        this.bufferSize = bufferSize;
        this.asyncIterator = new AsyncIterator((Iterator)this.backedIterator, bufferSize);
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasNextDocument() {
        return this.asyncIterator.hasNext();
    }

    @Override
    public LabelledDocument nextDocument() {
        return (LabelledDocument)this.asyncIterator.next();
    }

    @Override
    public void reset() {
        this.asyncIterator.shutdown();
        this.backedIterator.reset();
        this.asyncIterator = new AsyncIterator((Iterator)this.backedIterator, this.bufferSize);
    }

    @Override
    public void shutdown() {
        this.asyncIterator.shutdown();
        this.backedIterator.shutdown();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.backedIterator.getLabelsSource();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextDocument();
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    public AsyncIterator<LabelledDocument> getAsyncIterator() {
        return this.asyncIterator;
    }
}

