/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.loader;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;

public class VectorsConfiguration
implements Serializable {
    private int minWordFrequency = 5;
    private double learningRate = 0.025;
    private double minLearningRate = 1.0E-4;
    private int layersSize = 200;
    private boolean useAdaGrad = false;
    private int batchSize = 512;
    private int iterations = 1;
    private int epochs = 1;
    private int window = 5;
    private long seed;
    private double negative = 0.0;
    private boolean useHierarchicSoftmax = true;
    private double sampling = 0.0;
    private int learningRateDecayWords;
    private int[] variableWindows;
    private boolean hugeModelExpected = false;
    private int scavengerActivationThreshold = 2000000;
    private int scavengerRetentionDelay = 3;
    private String elementsLearningAlgorithm;
    private String sequenceLearningAlgorithm;
    private String modelUtils;
    private String UNK = "UNK";
    private String STOP = "STOP";
    private List<String> stopList = new ArrayList<String>();
    private int vocabSize;
    private boolean trainElementsVectors = true;
    private boolean allowParallelTokenization = false;
    private boolean preciseWeightInit = false;
    private static ObjectMapper mapper;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectMapper mapper() {
        if (mapper == null) {
            Object object = lock;
            synchronized (object) {
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                    mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
                    return mapper;
                }
            }
        }
        return mapper;
    }

    public String toJson() {
        ObjectMapper mapper = VectorsConfiguration.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toEncodedJson() {
        Base64 base64 = new Base64(Integer.MAX_VALUE);
        try {
            return base64.encodeAsString(this.toJson().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static VectorsConfiguration fromJson(String json) {
        ObjectMapper mapper = VectorsConfiguration.mapper();
        try {
            VectorsConfiguration ret = (VectorsConfiguration)mapper.readValue(json, VectorsConfiguration.class);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public int getLayersSize() {
        return this.layersSize;
    }

    public boolean isUseAdaGrad() {
        return this.useAdaGrad;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getEpochs() {
        return this.epochs;
    }

    public int getWindow() {
        return this.window;
    }

    public long getSeed() {
        return this.seed;
    }

    public double getNegative() {
        return this.negative;
    }

    public boolean isUseHierarchicSoftmax() {
        return this.useHierarchicSoftmax;
    }

    public double getSampling() {
        return this.sampling;
    }

    public int getLearningRateDecayWords() {
        return this.learningRateDecayWords;
    }

    public int[] getVariableWindows() {
        return this.variableWindows;
    }

    public boolean isHugeModelExpected() {
        return this.hugeModelExpected;
    }

    public int getScavengerActivationThreshold() {
        return this.scavengerActivationThreshold;
    }

    public int getScavengerRetentionDelay() {
        return this.scavengerRetentionDelay;
    }

    public String getElementsLearningAlgorithm() {
        return this.elementsLearningAlgorithm;
    }

    public String getSequenceLearningAlgorithm() {
        return this.sequenceLearningAlgorithm;
    }

    public String getModelUtils() {
        return this.modelUtils;
    }

    public String getUNK() {
        return this.UNK;
    }

    public String getSTOP() {
        return this.STOP;
    }

    public List<String> getStopList() {
        return this.stopList;
    }

    public int getVocabSize() {
        return this.vocabSize;
    }

    public boolean isTrainElementsVectors() {
        return this.trainElementsVectors;
    }

    public boolean isAllowParallelTokenization() {
        return this.allowParallelTokenization;
    }

    public boolean isPreciseWeightInit() {
        return this.preciseWeightInit;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public void setLayersSize(int layersSize) {
        this.layersSize = layersSize;
    }

    public void setUseAdaGrad(boolean useAdaGrad) {
        this.useAdaGrad = useAdaGrad;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setEpochs(int epochs) {
        this.epochs = epochs;
    }

    public void setWindow(int window) {
        this.window = window;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setNegative(double negative) {
        this.negative = negative;
    }

    public void setUseHierarchicSoftmax(boolean useHierarchicSoftmax) {
        this.useHierarchicSoftmax = useHierarchicSoftmax;
    }

    public void setSampling(double sampling) {
        this.sampling = sampling;
    }

    public void setLearningRateDecayWords(int learningRateDecayWords) {
        this.learningRateDecayWords = learningRateDecayWords;
    }

    public void setVariableWindows(int[] variableWindows) {
        this.variableWindows = variableWindows;
    }

    public void setHugeModelExpected(boolean hugeModelExpected) {
        this.hugeModelExpected = hugeModelExpected;
    }

    public void setScavengerActivationThreshold(int scavengerActivationThreshold) {
        this.scavengerActivationThreshold = scavengerActivationThreshold;
    }

    public void setScavengerRetentionDelay(int scavengerRetentionDelay) {
        this.scavengerRetentionDelay = scavengerRetentionDelay;
    }

    public void setElementsLearningAlgorithm(String elementsLearningAlgorithm) {
        this.elementsLearningAlgorithm = elementsLearningAlgorithm;
    }

    public void setSequenceLearningAlgorithm(String sequenceLearningAlgorithm) {
        this.sequenceLearningAlgorithm = sequenceLearningAlgorithm;
    }

    public void setModelUtils(String modelUtils) {
        this.modelUtils = modelUtils;
    }

    public void setUNK(String UNK) {
        this.UNK = UNK;
    }

    public void setSTOP(String STOP) {
        this.STOP = STOP;
    }

    public void setStopList(List<String> stopList) {
        this.stopList = stopList;
    }

    public void setVocabSize(int vocabSize) {
        this.vocabSize = vocabSize;
    }

    public void setTrainElementsVectors(boolean trainElementsVectors) {
        this.trainElementsVectors = trainElementsVectors;
    }

    public void setAllowParallelTokenization(boolean allowParallelTokenization) {
        this.allowParallelTokenization = allowParallelTokenization;
    }

    public void setPreciseWeightInit(boolean preciseWeightInit) {
        this.preciseWeightInit = preciseWeightInit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorsConfiguration)) {
            return false;
        }
        VectorsConfiguration other = (VectorsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinWordFrequency() != other.getMinWordFrequency()) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinLearningRate(), other.getMinLearningRate()) != 0) {
            return false;
        }
        if (this.getLayersSize() != other.getLayersSize()) {
            return false;
        }
        if (this.isUseAdaGrad() != other.isUseAdaGrad()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getIterations() != other.getIterations()) {
            return false;
        }
        if (this.getEpochs() != other.getEpochs()) {
            return false;
        }
        if (this.getWindow() != other.getWindow()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (Double.compare(this.getNegative(), other.getNegative()) != 0) {
            return false;
        }
        if (this.isUseHierarchicSoftmax() != other.isUseHierarchicSoftmax()) {
            return false;
        }
        if (Double.compare(this.getSampling(), other.getSampling()) != 0) {
            return false;
        }
        if (this.getLearningRateDecayWords() != other.getLearningRateDecayWords()) {
            return false;
        }
        if (!Arrays.equals(this.getVariableWindows(), other.getVariableWindows())) {
            return false;
        }
        if (this.isHugeModelExpected() != other.isHugeModelExpected()) {
            return false;
        }
        if (this.getScavengerActivationThreshold() != other.getScavengerActivationThreshold()) {
            return false;
        }
        if (this.getScavengerRetentionDelay() != other.getScavengerRetentionDelay()) {
            return false;
        }
        String this$elementsLearningAlgorithm = this.getElementsLearningAlgorithm();
        String other$elementsLearningAlgorithm = other.getElementsLearningAlgorithm();
        if (this$elementsLearningAlgorithm == null ? other$elementsLearningAlgorithm != null : !this$elementsLearningAlgorithm.equals(other$elementsLearningAlgorithm)) {
            return false;
        }
        String this$sequenceLearningAlgorithm = this.getSequenceLearningAlgorithm();
        String other$sequenceLearningAlgorithm = other.getSequenceLearningAlgorithm();
        if (this$sequenceLearningAlgorithm == null ? other$sequenceLearningAlgorithm != null : !this$sequenceLearningAlgorithm.equals(other$sequenceLearningAlgorithm)) {
            return false;
        }
        String this$modelUtils = this.getModelUtils();
        String other$modelUtils = other.getModelUtils();
        if (this$modelUtils == null ? other$modelUtils != null : !this$modelUtils.equals(other$modelUtils)) {
            return false;
        }
        String this$UNK = this.getUNK();
        String other$UNK = other.getUNK();
        if (this$UNK == null ? other$UNK != null : !this$UNK.equals(other$UNK)) {
            return false;
        }
        String this$STOP = this.getSTOP();
        String other$STOP = other.getSTOP();
        if (this$STOP == null ? other$STOP != null : !this$STOP.equals(other$STOP)) {
            return false;
        }
        List<String> this$stopList = this.getStopList();
        List<String> other$stopList = other.getStopList();
        if (this$stopList == null ? other$stopList != null : !((Object)this$stopList).equals(other$stopList)) {
            return false;
        }
        if (this.getVocabSize() != other.getVocabSize()) {
            return false;
        }
        if (this.isTrainElementsVectors() != other.isTrainElementsVectors()) {
            return false;
        }
        if (this.isAllowParallelTokenization() != other.isAllowParallelTokenization()) {
            return false;
        }
        return this.isPreciseWeightInit() == other.isPreciseWeightInit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinWordFrequency();
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $minLearningRate = Double.doubleToLongBits(this.getMinLearningRate());
        result = result * 59 + (int)($minLearningRate >>> 32 ^ $minLearningRate);
        result = result * 59 + this.getLayersSize();
        result = result * 59 + (this.isUseAdaGrad() ? 79 : 97);
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getIterations();
        result = result * 59 + this.getEpochs();
        result = result * 59 + this.getWindow();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        long $negative = Double.doubleToLongBits(this.getNegative());
        result = result * 59 + (int)($negative >>> 32 ^ $negative);
        result = result * 59 + (this.isUseHierarchicSoftmax() ? 79 : 97);
        long $sampling = Double.doubleToLongBits(this.getSampling());
        result = result * 59 + (int)($sampling >>> 32 ^ $sampling);
        result = result * 59 + this.getLearningRateDecayWords();
        result = result * 59 + Arrays.hashCode(this.getVariableWindows());
        result = result * 59 + (this.isHugeModelExpected() ? 79 : 97);
        result = result * 59 + this.getScavengerActivationThreshold();
        result = result * 59 + this.getScavengerRetentionDelay();
        String $elementsLearningAlgorithm = this.getElementsLearningAlgorithm();
        result = result * 59 + ($elementsLearningAlgorithm == null ? 43 : $elementsLearningAlgorithm.hashCode());
        String $sequenceLearningAlgorithm = this.getSequenceLearningAlgorithm();
        result = result * 59 + ($sequenceLearningAlgorithm == null ? 43 : $sequenceLearningAlgorithm.hashCode());
        String $modelUtils = this.getModelUtils();
        result = result * 59 + ($modelUtils == null ? 43 : $modelUtils.hashCode());
        String $UNK = this.getUNK();
        result = result * 59 + ($UNK == null ? 43 : $UNK.hashCode());
        String $STOP = this.getSTOP();
        result = result * 59 + ($STOP == null ? 43 : $STOP.hashCode());
        List<String> $stopList = this.getStopList();
        result = result * 59 + ($stopList == null ? 43 : ((Object)$stopList).hashCode());
        result = result * 59 + this.getVocabSize();
        result = result * 59 + (this.isTrainElementsVectors() ? 79 : 97);
        result = result * 59 + (this.isAllowParallelTokenization() ? 79 : 97);
        result = result * 59 + (this.isPreciseWeightInit() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "VectorsConfiguration(minWordFrequency=" + this.getMinWordFrequency() + ", learningRate=" + this.getLearningRate() + ", minLearningRate=" + this.getMinLearningRate() + ", layersSize=" + this.getLayersSize() + ", useAdaGrad=" + this.isUseAdaGrad() + ", batchSize=" + this.getBatchSize() + ", iterations=" + this.getIterations() + ", epochs=" + this.getEpochs() + ", window=" + this.getWindow() + ", seed=" + this.getSeed() + ", negative=" + this.getNegative() + ", useHierarchicSoftmax=" + this.isUseHierarchicSoftmax() + ", sampling=" + this.getSampling() + ", learningRateDecayWords=" + this.getLearningRateDecayWords() + ", variableWindows=" + Arrays.toString(this.getVariableWindows()) + ", hugeModelExpected=" + this.isHugeModelExpected() + ", scavengerActivationThreshold=" + this.getScavengerActivationThreshold() + ", scavengerRetentionDelay=" + this.getScavengerRetentionDelay() + ", elementsLearningAlgorithm=" + this.getElementsLearningAlgorithm() + ", sequenceLearningAlgorithm=" + this.getSequenceLearningAlgorithm() + ", modelUtils=" + this.getModelUtils() + ", UNK=" + this.getUNK() + ", STOP=" + this.getSTOP() + ", stopList=" + this.getStopList() + ", vocabSize=" + this.getVocabSize() + ", trainElementsVectors=" + this.isTrainElementsVectors() + ", allowParallelTokenization=" + this.isAllowParallelTokenization() + ", preciseWeightInit=" + this.isPreciseWeightInit() + ")";
    }

    static {
        lock = new Object();
    }
}

