/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator.labelaware;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.deeplearning4j.util.StringGrid;

public class LabelAwareListSentenceIterator
implements LabelAwareSentenceIterator {
    private int currPosition;
    private List<String> labels;
    private List<String> text;
    private String currentLabel;
    private SentencePreProcessor sentencePreProcessor;

    public LabelAwareListSentenceIterator(InputStream is, String delimiter, int labelPosition, int textPosition) throws IOException {
        StringGrid grid = StringGrid.fromInput((InputStream)is, (String)delimiter);
        this.labels = grid.getColumn(labelPosition);
        this.text = grid.getColumn(textPosition);
        is.close();
    }

    public LabelAwareListSentenceIterator(InputStream is) throws IOException {
        this(is, "\t", 0, 1);
    }

    public LabelAwareListSentenceIterator(InputStream is, String sep) throws IOException {
        this(is, sep, 0, 1);
    }

    @Override
    public synchronized String currentLabel() {
        return this.currentLabel;
    }

    @Override
    public List<String> currentLabels() {
        return Arrays.asList(this.currentLabel);
    }

    @Override
    public String nextSentence() {
        String ret = this.text.get(this.currPosition);
        this.currentLabel = this.labels.get(this.currPosition);
        if (this.sentencePreProcessor != null) {
            ret = this.sentencePreProcessor.preProcess(ret);
        }
        ++this.currPosition;
        return ret;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.currPosition < this.text.size();
    }

    @Override
    public void reset() {
        this.currPosition = 0;
    }

    @Override
    public void finish() {
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.sentencePreProcessor;
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.sentencePreProcessor = preProcessor;
    }
}

