/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec.wordstore;

import java.util.Arrays;
import lombok.NonNull;

public class HuffmanNode {
    @NonNull
    private byte[] code;
    @NonNull
    private int[] point;
    private int idx;
    private byte length;

    public HuffmanNode() {
    }

    public HuffmanNode(byte[] code, int[] point, int index, byte length) {
        this.code = code;
        this.point = point;
        this.idx = index;
        this.length = length;
    }

    @NonNull
    public byte[] getCode() {
        return this.code;
    }

    @NonNull
    public int[] getPoint() {
        return this.point;
    }

    public int getIdx() {
        return this.idx;
    }

    public byte getLength() {
        return this.length;
    }

    public void setCode(@NonNull byte[] code) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        this.code = code;
    }

    public void setPoint(@NonNull int[] point) {
        if (point == null) {
            throw new NullPointerException("point");
        }
        this.point = point;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public void setLength(byte length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuffmanNode)) {
            return false;
        }
        HuffmanNode other = (HuffmanNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getCode(), other.getCode())) {
            return false;
        }
        if (!Arrays.equals(this.getPoint(), other.getPoint())) {
            return false;
        }
        if (this.getIdx() != other.getIdx()) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HuffmanNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getCode());
        result = result * 59 + Arrays.hashCode(this.getPoint());
        result = result * 59 + this.getIdx();
        result = result * 59 + this.getLength();
        return result;
    }

    public String toString() {
        return "HuffmanNode(code=" + Arrays.toString(this.getCode()) + ", point=" + Arrays.toString(this.getPoint()) + ", idx=" + this.getIdx() + ", length=" + this.getLength() + ")";
    }
}

