/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.transformers.impl.iterables;

import java.util.Iterator;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTransformerIterator
implements Iterator<Sequence<VocabWord>> {
    private static final Logger log = LoggerFactory.getLogger(BasicTransformerIterator.class);
    protected final LabelAwareIterator iterator;
    protected boolean allowMultithreading;
    protected final SentenceTransformer sentenceTransformer;

    public BasicTransformerIterator(@NonNull LabelAwareIterator iterator, @NonNull SentenceTransformer transformer) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer");
        }
        this.iterator = iterator;
        this.allowMultithreading = false;
        this.sentenceTransformer = transformer;
        this.iterator.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNextDocument();
    }

    @Override
    public Sequence<VocabWord> next() {
        LabelledDocument document = this.iterator.nextDocument();
        if (document.getContent() == null) {
            return new Sequence<VocabWord>();
        }
        Sequence<VocabWord> sequence = this.sentenceTransformer.transformToSequence(document.getContent());
        for (String label : document.getLabels()) {
            sequence.addSequenceLabel(new VocabWord(1.0, label));
        }
        return sequence;
    }

    public void reset() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

