/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.RandomUtils;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.nd4j.linalg.api.ops.aggregates.impl.AggregateSkipGram;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.DeviceLocalNDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipGram<T extends SequenceElement>
implements ElementsLearningAlgorithm<T> {
    private static final Logger log = LoggerFactory.getLogger(SkipGram.class);
    protected VocabCache<T> vocabCache;
    protected WeightLookupTable<T> lookupTable;
    protected VectorsConfiguration configuration;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected int[] variableWindows;
    protected int vectorLength;
    protected DeviceLocalNDArray syn0;
    protected DeviceLocalNDArray syn1;
    protected DeviceLocalNDArray syn1Neg;
    protected DeviceLocalNDArray table;
    protected DeviceLocalNDArray expTable;
    protected ThreadLocal<List<Aggregate>> batches = new ThreadLocal();

    public List<Aggregate> getBatch() {
        return this.batches.get();
    }

    @Override
    public String getCodeName() {
        return "SkipGram";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        if (configuration.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() == null) {
            log.info("Initializing syn1Neg...");
            ((InMemoryLookupTable)lookupTable).setUseHS(configuration.isUseHierarchicSoftmax());
            ((InMemoryLookupTable)lookupTable).setNegative(configuration.getNegative());
            ((InMemoryLookupTable)lookupTable).resetWeights(false);
        }
        this.expTable = new DeviceLocalNDArray(Nd4j.create((double[])((InMemoryLookupTable)lookupTable).getExpTable()));
        this.syn0 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn0());
        this.syn1 = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1());
        this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getSyn1Neg());
        this.table = new DeviceLocalNDArray(((InMemoryLookupTable)lookupTable).getTable());
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        this.variableWindows = configuration.getVariableWindows();
        this.vectorLength = configuration.getLayersSize();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    public Sequence<T> applySubsampling(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> result = new Sequence<T>();
        if (this.sampling > 0.0) {
            result.setSequenceId(sequence.getSequenceId());
            if (sequence.getSequenceLabels() != null) {
                result.setSequenceLabels(sequence.getSequenceLabels());
            }
            if (sequence.getSequenceLabel() != null) {
                result.setSequenceLabel(sequence.getSequenceLabel());
            }
            for (SequenceElement element : sequence.getElements()) {
                double numWords = this.vocabCache.totalWordOccurrences();
                double ran = (Math.sqrt(element.getElementFrequency() / (this.sampling * numWords)) + 1.0) * (this.sampling * numWords) / element.getElementFrequency();
                nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                result.addElement(element);
            }
            return result;
        }
        return sequence;
    }

    @Override
    public double learnSequence(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom, double learningRate) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        double score = 0.0;
        int currentWindow = this.window;
        if (this.variableWindows != null && this.variableWindows.length != 0) {
            currentWindow = this.variableWindows[RandomUtils.nextInt(this.variableWindows.length)];
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            score = this.skipGram(i, tempSequence.getElements(), (int)nextRandom.get() % currentWindow, nextRandom, learningRate, currentWindow);
        }
        if (this.batches.get().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
        return score;
    }

    @Override
    public void finish() {
        if (this.batches != null && this.batches.get() != null && this.batches.get().size() > 0) {
            Nd4j.getExecutioner().exec(this.batches.get());
            this.batches.get().clear();
        }
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    private double skipGram(int i, List<T> sentence, int b, AtomicLong nextRandom, double alpha, int currentWindow) {
        SequenceElement word = (SequenceElement)sentence.get(i);
        if (word == null || sentence.isEmpty()) {
            return 0.0;
        }
        double score = 0.0;
        boolean cnt = false;
        int end = currentWindow * 2 + 1 - b;
        for (int a = b; a < end; ++a) {
            int c;
            if (a == currentWindow || (c = i - currentWindow + a) < 0 || c >= sentence.size()) continue;
            SequenceElement lastWord = (SequenceElement)sentence.get(c);
            score = this.iterateSample(word, lastWord, nextRandom, alpha, false, null);
        }
        return score;
    }

    public double iterateSample(T w1, T lastWord, AtomicLong nextRandom, double alpha, boolean isInference, INDArray inferenceVector) {
        if (w1 == null || lastWord == null || ((SequenceElement)lastWord).getIndex() < 0 || ((SequenceElement)w1).getIndex() == ((SequenceElement)lastWord).getIndex() || ((SequenceElement)w1).getLabel().equals("STOP") || ((SequenceElement)lastWord).getLabel().equals("STOP") || ((SequenceElement)w1).getLabel().equals("UNK") || ((SequenceElement)lastWord).getLabel().equals("UNK")) {
            return 0.0;
        }
        double score = 0.0;
        int[] idxSyn1 = null;
        int[] codes = null;
        if (this.configuration.isUseHierarchicSoftmax()) {
            idxSyn1 = new int[((SequenceElement)w1).getCodeLength()];
            codes = new int[((SequenceElement)w1).getCodeLength()];
            for (int i = 0; i < ((SequenceElement)w1).getCodeLength(); ++i) {
                int code = ((SequenceElement)w1).getCodes().get(i);
                int point = ((SequenceElement)w1).getPoints().get(i);
                if (point >= this.vocabCache.numWords() || point < 0) continue;
                codes[i] = code;
                idxSyn1[i] = point;
            }
        } else {
            idxSyn1 = new int[]{};
            codes = new int[]{};
        }
        int target = ((SequenceElement)w1).getIndex();
        if (this.negative > 0.0 && this.syn1Neg == null) {
            ((InMemoryLookupTable)this.lookupTable).initNegative();
            this.syn1Neg = new DeviceLocalNDArray(((InMemoryLookupTable)this.lookupTable).getSyn1Neg());
        }
        if (this.batches.get() == null) {
            this.batches.set(new ArrayList());
        }
        AggregateSkipGram sg = new AggregateSkipGram((INDArray)this.syn0.get(), (INDArray)this.syn1.get(), (INDArray)this.syn1Neg.get(), (INDArray)this.expTable.get(), (INDArray)this.table.get(), ((SequenceElement)lastWord).getIndex(), idxSyn1, codes, (int)this.negative, target, this.vectorLength, alpha, nextRandom.get(), this.vocabCache.numWords(), inferenceVector);
        nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
        if (!isInference) {
            this.batches.get().add((Aggregate)sg);
        } else {
            Nd4j.getExecutioner().exec((Aggregate)sg);
        }
        return score;
    }

    public DeviceLocalNDArray getSyn0() {
        return this.syn0;
    }

    public DeviceLocalNDArray getSyn1() {
        return this.syn1;
    }

    public DeviceLocalNDArray getSyn1Neg() {
        return this.syn1Neg;
    }

    public DeviceLocalNDArray getTable() {
        return this.table;
    }

    public DeviceLocalNDArray getExpTable() {
        return this.expTable;
    }

    public void setSyn0(DeviceLocalNDArray syn0) {
        this.syn0 = syn0;
    }

    public void setSyn1(DeviceLocalNDArray syn1) {
        this.syn1 = syn1;
    }

    public void setSyn1Neg(DeviceLocalNDArray syn1Neg) {
        this.syn1Neg = syn1Neg;
    }

    public void setTable(DeviceLocalNDArray table) {
        this.table = table;
    }

    public void setExpTable(DeviceLocalNDArray expTable) {
        this.expTable = expTable;
    }
}

