/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.loader;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.reader.impl.BasicModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectorsImpl;
import org.deeplearning4j.models.glove.Glove;
import org.deeplearning4j.models.paragraphvectors.ParagraphVectors;
import org.deeplearning4j.models.sequencevectors.SequenceVectors;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceElementFactory;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.sequencevectors.serialization.VocabWordFactory;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyHolder;
import org.deeplearning4j.models.word2vec.wordstore.VocabularyWord;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.AbstractCache;
import org.deeplearning4j.models.word2vec.wordstore.inmemory.InMemoryLookupCache;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.sentenceiterator.BasicLineIterator;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordVectorSerializer {
    private static final boolean DEFAULT_LINEBREAKS = false;
    private static final boolean HAS_HEADER = true;
    private static final int MAX_SIZE = 50;
    private static final String whitespaceReplacement = "_Az92_";
    private static final Logger log = LoggerFactory.getLogger(WordVectorSerializer.class);

    private WordVectorSerializer() {
    }

    public static WordVectors loadGoogleModel(File modelFile, boolean binary) throws IOException {
        return WordVectorSerializer.loadGoogleModel(modelFile, binary, false);
    }

    public static WordVectors loadGoogleModel(File modelFile, boolean binary, boolean lineBreaks) throws IOException {
        return binary ? WordVectorSerializer.readBinaryModel(modelFile, lineBreaks, true) : WordVectorSerializer.fromPair(WordVectorSerializer.loadTxt(modelFile));
    }

    public static WordVectors loadGoogleModelNonNormalized(File modelFile, boolean binary, boolean lineBreaks) throws IOException {
        return binary ? WordVectorSerializer.readBinaryModel(modelFile, lineBreaks, false) : WordVectorSerializer.fromPair(WordVectorSerializer.loadTxt(modelFile));
    }

    private static Word2Vec readTextModel(File modelFile) throws IOException, NumberFormatException {
        Word2Vec ret = new Word2Vec();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(GzipUtils.isCompressedFilename((String)modelFile.getName()) ? new GZIPInputStream(new FileInputStream(modelFile)) : new FileInputStream(modelFile), "UTF-8"));){
            String line = reader.readLine();
            String[] initial = line.split(" ");
            int words = Integer.parseInt(initial[0]);
            int layerSize = Integer.parseInt(initial[1]);
            INDArray syn0 = Nd4j.create((int)words, (int)layerSize);
            InMemoryLookupCache cache = new InMemoryLookupCache(false);
            int currLine = 0;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                assert (split.length == layerSize + 1);
                String word = split[0].replaceAll(whitespaceReplacement, " ");
                float[] vector = new float[split.length - 1];
                for (int i = 1; i < split.length; ++i) {
                    vector[i - 1] = Float.parseFloat(split[i]);
                }
                syn0.putRow(currLine, Nd4j.create((float[])vector));
                cache.addWordToIndex(cache.numWords(), word);
                cache.addToken(new VocabWord(1.0, word));
                cache.putVocabWord(word);
                ++currLine;
            }
            InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder<VocabWord>().cache(cache).vectorLength(layerSize).build();
            lookupTable.setSyn0(syn0);
            ret.setVocab(cache);
            ret.setLookupTable(lookupTable);
        }
        return ret;
    }

    private static Word2Vec readBinaryModel(File modelFile, boolean linebreaks, boolean normalize) throws NumberFormatException, IOException {
        InMemoryLookupTable lookupTable;
        InMemoryLookupCache cache;
        INDArray syn0;
        try (BufferedInputStream bis = new BufferedInputStream(GzipUtils.isCompressedFilename((String)modelFile.getName()) ? new GZIPInputStream(new FileInputStream(modelFile)) : new FileInputStream(modelFile));
             DataInputStream dis = new DataInputStream(bis);){
            int words = Integer.parseInt(WordVectorSerializer.readString(dis));
            int size = Integer.parseInt(WordVectorSerializer.readString(dis));
            syn0 = Nd4j.create((int)words, (int)size);
            cache = new InMemoryLookupCache(false);
            lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder<VocabWord>().cache(cache).vectorLength(size).build();
            for (int i = 0; i < words; ++i) {
                String word = WordVectorSerializer.readString(dis);
                log.trace("Loading " + word + " with word " + i);
                float[] vector = new float[size];
                for (int j = 0; j < size; ++j) {
                    vector[j] = WordVectorSerializer.readFloat(dis);
                }
                syn0.putRow(i, normalize ? Transforms.unitVec((INDArray)Nd4j.create((float[])vector)) : Nd4j.create((float[])vector));
                cache.addToken(new VocabWord(1.0, word));
                cache.addWordToIndex(cache.numWords(), word);
                cache.putVocabWord(word);
                if (!linebreaks) continue;
                dis.readByte();
            }
        }
        Word2Vec ret = new Word2Vec();
        lookupTable.setSyn0(syn0);
        ret.setVocab(cache);
        ret.setLookupTable(lookupTable);
        return ret;
    }

    public static float readFloat(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        is.read(bytes);
        return WordVectorSerializer.getFloat(bytes);
    }

    public static float getFloat(byte[] b) {
        int accum = 0;
        accum |= (b[0] & 0xFF) << 0;
        accum |= (b[1] & 0xFF) << 8;
        accum |= (b[2] & 0xFF) << 16;
        return Float.intBitsToFloat(accum |= (b[3] & 0xFF) << 24);
    }

    public static String readString(DataInputStream dis) throws IOException {
        byte[] bytes = new byte[50];
        byte b = dis.readByte();
        int i = -1;
        StringBuilder sb = new StringBuilder();
        while (b != 32 && b != 10) {
            bytes[++i] = b;
            b = dis.readByte();
            if (i != 49) continue;
            sb.append(new String(bytes, "UTF-8"));
            i = -1;
            bytes = new byte[50];
        }
        sb.append(new String(bytes, 0, i + 1, "UTF-8"));
        return sb.toString();
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, String path) throws IOException {
        try {
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)new FileOutputStream(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, File file) throws IOException {
        try {
            WordVectorSerializer.writeWordVectors(lookupTable, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends SequenceElement> void writeWordVectors(WeightLookupTable<T> lookupTable, OutputStream stream) throws IOException {
        VocabCache<T> vocabCache = lookupTable.getVocabCache();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        for (int x = 0; x < vocabCache.numWords(); ++x) {
            T element = vocabCache.elementAtIndex(x);
            StringBuilder builder = new StringBuilder();
            builder.append(((SequenceElement)element).getLabel().replaceAll(" ", whitespaceReplacement)).append(" ");
            INDArray vec = lookupTable.vector(((SequenceElement)element).getLabel());
            for (int i = 0; i < vec.length(); ++i) {
                builder.append(vec.getDouble(i));
                if (i >= vec.length() - 1) continue;
                builder.append(" ");
            }
            writer.println(builder.toString());
        }
        writer.flush();
        writer.close();
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull File path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(@NonNull ParagraphVectors vectors, @NonNull String path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, File file) {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            WordVectorSerializer.writeParagraphVectors(vectors, stream);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, String path) {
        WordVectorSerializer.writeParagraphVectors(vectors, new File(path));
    }

    public static void writeWord2Vec(Word2Vec vectors, File file) {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            WordVectorSerializer.writeWord2Vec(vectors, stream);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWord2Vec(Word2Vec vectors, String path) {
        WordVectorSerializer.writeWord2Vec(vectors, new File(path));
    }

    public static void writeWord2Vec(Word2Vec vectors, OutputStream stream) throws IOException {
        int i;
        Serializable builder;
        ZipOutputStream zipfile = new ZipOutputStream((OutputStream)new CloseShieldOutputStream(stream));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = File.createTempFile("word2vec", "0");
        tempFileSyn0.deleteOnExit();
        WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
        FileInputStream fis = new FileInputStream(tempFileSyn0);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileSyn1 = File.createTempFile("word2vec", "1");
        tempFileSyn1.deleteOnExit();
        INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
            for (int x = 0; x < syn1.rows(); ++x) {
                INDArray row = syn1.getRow(x);
                builder = new StringBuilder();
                for (i = 0; i < row.length(); ++i) {
                    ((StringBuilder)builder).append(row.getDouble(i)).append(" ");
                }
                writer.println(((StringBuilder)builder).toString().trim());
            }
        }
        ZipEntry zSyn1 = new ZipEntry("syn1.txt");
        zipfile.putNextEntry(zSyn1);
        fis = new FileInputStream(tempFileSyn1);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileCodes = File.createTempFile("word2vec", "h");
        tempFileCodes.deleteOnExit();
        ZipEntry hC = new ZipEntry("codes.txt");
        zipfile.putNextEntry(hC);
        PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));
        builder = null;
        try {
            for (i = 0; i < vectors.getVocab().numWords(); ++i) {
                VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                StringBuilder builder2 = new StringBuilder(word.getLabel()).append(" ");
                for (int code : word.getCodes()) {
                    builder2.append(code).append(" ");
                }
                writer.println(builder2.toString().trim());
            }
        }
        catch (Throwable i2) {
            builder = i2;
            throw i2;
        }
        finally {
            if (writer != null) {
                if (builder != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable i2) {
                        ((Throwable)builder).addSuppressed(i2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        fis = new FileInputStream(tempFileCodes);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileHuffman = File.createTempFile("word2vec", "h");
        tempFileHuffman.deleteOnExit();
        ZipEntry hP = new ZipEntry("huffman.txt");
        zipfile.putNextEntry(hP);
        try (PrintWriter writer2 = new PrintWriter(new FileWriter(tempFileHuffman));){
            for (int i3 = 0; i3 < vectors.getVocab().numWords(); ++i3) {
                VocabWord word = (VocabWord)vectors.getVocab().elementAtIndex(i3);
                StringBuilder builder3 = new StringBuilder(word.getLabel()).append(" ");
                for (int point : word.getPoints()) {
                    builder3.append(point).append(" ");
                }
                writer2.println(builder3.toString().trim());
            }
        }
        fis = new FileInputStream(tempFileHuffman);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        ZipEntry config = new ZipEntry("config.json");
        zipfile.putNextEntry(config);
        WordVectorSerializer.writeEntry(new ByteArrayInputStream(vectors.getConfiguration().toJson().getBytes()), zipfile);
        zipfile.flush();
        zipfile.close();
    }

    public static void writeParagraphVectors(ParagraphVectors vectors, OutputStream stream) throws IOException {
        Serializable word;
        int i;
        Serializable builder;
        ZipOutputStream zipfile = new ZipOutputStream((OutputStream)new CloseShieldOutputStream(stream));
        ZipEntry syn0 = new ZipEntry("syn0.txt");
        zipfile.putNextEntry(syn0);
        File tempFileSyn0 = File.createTempFile("paravec", "0");
        tempFileSyn0.deleteOnExit();
        WordVectorSerializer.writeWordVectors(vectors.lookupTable(), tempFileSyn0);
        FileInputStream fis = new FileInputStream(tempFileSyn0);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileSyn1 = File.createTempFile("paravec", "1");
        tempFileSyn1.deleteOnExit();
        INDArray syn1 = ((InMemoryLookupTable)vectors.getLookupTable()).getSyn1();
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempFileSyn1));){
            for (int x = 0; x < syn1.rows(); ++x) {
                INDArray row = syn1.getRow(x);
                builder = new StringBuilder();
                for (i = 0; i < row.length(); ++i) {
                    ((StringBuilder)builder).append(row.getDouble(i)).append(" ");
                }
                writer.println(((StringBuilder)builder).toString().trim());
            }
        }
        ZipEntry zSyn1 = new ZipEntry("syn1.txt");
        zipfile.putNextEntry(zSyn1);
        fis = new FileInputStream(tempFileSyn1);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileCodes = File.createTempFile("paravec", "h");
        tempFileCodes.deleteOnExit();
        ZipEntry hC = new ZipEntry("codes.txt");
        zipfile.putNextEntry(hC);
        PrintWriter writer = new PrintWriter(new FileWriter(tempFileCodes));
        builder = null;
        try {
            for (i = 0; i < vectors.getVocab().numWords(); ++i) {
                word = (VocabWord)vectors.getVocab().elementAtIndex(i);
                StringBuilder builder2 = new StringBuilder(((VocabWord)word).getLabel()).append(" ");
                for (int code : ((SequenceElement)word).getCodes()) {
                    builder2.append(code).append(" ");
                }
                writer.println(builder2.toString().trim());
            }
        }
        catch (Throwable i2) {
            builder = i2;
            throw i2;
        }
        finally {
            if (writer != null) {
                if (builder != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable i2) {
                        ((Throwable)builder).addSuppressed(i2);
                    }
                } else {
                    writer.close();
                }
            }
        }
        fis = new FileInputStream(tempFileCodes);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        File tempFileHuffman = File.createTempFile("paravec", "h");
        tempFileHuffman.deleteOnExit();
        ZipEntry hP = new ZipEntry("huffman.txt");
        zipfile.putNextEntry(hP);
        PrintWriter writer2 = new PrintWriter(new FileWriter(tempFileHuffman));
        word = null;
        try {
            for (int i3 = 0; i3 < vectors.getVocab().numWords(); ++i3) {
                VocabWord word2 = (VocabWord)vectors.getVocab().elementAtIndex(i3);
                StringBuilder builder3 = new StringBuilder(word2.getLabel()).append(" ");
                for (int point : word2.getPoints()) {
                    builder3.append(point).append(" ");
                }
                writer2.println(builder3.toString().trim());
            }
        }
        catch (Throwable i3) {
            word = i3;
            throw i3;
        }
        finally {
            if (writer2 != null) {
                if (word != null) {
                    try {
                        writer2.close();
                    }
                    catch (Throwable i3) {
                        ((Throwable)word).addSuppressed(i3);
                    }
                } else {
                    writer2.close();
                }
            }
        }
        fis = new FileInputStream(tempFileHuffman);
        WordVectorSerializer.writeEntry(fis, zipfile);
        fis.close();
        ZipEntry config = new ZipEntry("config.json");
        zipfile.putNextEntry(config);
        WordVectorSerializer.writeEntry(new ByteArrayInputStream(vectors.getConfiguration().toJson().getBytes()), zipfile);
        ZipEntry labels = new ZipEntry("labels.txt");
        zipfile.putNextEntry(labels);
        StringBuilder builder4 = new StringBuilder();
        for (VocabWord word3 : vectors.getVocab().tokens()) {
            if (!word3.isLabel()) continue;
            builder4.append(word3.getLabel()).append("\n");
        }
        WordVectorSerializer.writeEntry(new ByteArrayInputStream(builder4.toString().trim().getBytes()), zipfile);
        zipfile.flush();
        zipfile.close();
    }

    public static ParagraphVectors readParagraphVectors(String path) throws IOException {
        return WordVectorSerializer.readParagraphVectors(new File(path));
    }

    public static ParagraphVectors readParagraphVectors(File file) throws IOException {
        File tmpFileL = File.createTempFile("paravec", "l");
        tmpFileL.deleteOnExit();
        Word2Vec w2v = WordVectorSerializer.readWord2Vec(file);
        ParagraphVectors vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder(w2v.getConfiguration()).vocabCache(w2v.getVocab())).lookupTable(w2v.getLookupTable())).resetModel(false).build();
        ZipFile zipFile = new ZipFile(file);
        ZipEntry labels = zipFile.getEntry("labels.txt");
        if (labels != null) {
            InputStream stream = zipFile.getInputStream(labels);
            Files.copy(stream, Paths.get(tmpFileL.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            try (BufferedReader reader = new BufferedReader(new FileReader(tmpFileL));){
                String line;
                while ((line = reader.readLine()) != null) {
                    VocabWord word = (VocabWord)vectors.getVocab().tokenFor(line.trim());
                    if (word == null) continue;
                    word.markAsLabel(true);
                }
            }
        }
        return vectors;
    }

    public static Word2Vec readWord2Vec(File file) throws IOException {
        File tmpFileSyn0 = File.createTempFile("word2vec", "0");
        File tmpFileSyn1 = File.createTempFile("word2vec", "1");
        File tmpFileC = File.createTempFile("word2vec", "c");
        File tmpFileH = File.createTempFile("word2vec", "h");
        tmpFileSyn0.deleteOnExit();
        tmpFileSyn1.deleteOnExit();
        tmpFileH.deleteOnExit();
        tmpFileC.deleteOnExit();
        ZipFile zipFile = new ZipFile(file);
        ZipEntry syn0 = zipFile.getEntry("syn0.txt");
        InputStream stream = zipFile.getInputStream(syn0);
        Files.copy(stream, Paths.get(tmpFileSyn0.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        ZipEntry syn1 = zipFile.getEntry("syn1.txt");
        stream = zipFile.getInputStream(syn1);
        Files.copy(stream, Paths.get(tmpFileSyn1.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        ZipEntry codes = zipFile.getEntry("codes.txt");
        stream = zipFile.getInputStream(codes);
        Files.copy(stream, Paths.get(tmpFileC.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        ZipEntry huffman = zipFile.getEntry("huffman.txt");
        stream = zipFile.getInputStream(huffman);
        Files.copy(stream, Paths.get(tmpFileH.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        ZipEntry config = zipFile.getEntry("config.json");
        stream = zipFile.getInputStream(config);
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
        }
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(builder.toString().trim());
        Word2Vec w2v = WordVectorSerializer.readWord2VecFromText(tmpFileSyn0, tmpFileSyn1, tmpFileC, tmpFileH, configuration);
        return w2v;
    }

    public static ParagraphVectors readParagraphVectors(InputStream stream) throws IOException {
        File tmpFile = File.createTempFile("restore", "paravec");
        Files.copy(stream, Paths.get(tmpFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return WordVectorSerializer.readParagraphVectors(tmpFile);
    }

    private static void writeEntry(InputStream inputStream, ZipOutputStream zipStream) throws IOException {
        int bytesRead;
        byte[] bytes = new byte[1024];
        while ((bytesRead = inputStream.read(bytes)) != -1) {
            zipStream.write(bytes, 0, bytesRead);
        }
    }

    public static Word2Vec readWord2VecFromText(@NonNull File vectors, @NonNull File hs, @NonNull File h_codes, @NonNull File h_points, @NonNull VectorsConfiguration configuration) throws IOException {
        int i;
        String[] split;
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (hs == null) {
            throw new NullPointerException("hs");
        }
        if (h_codes == null) {
            throw new NullPointerException("h_codes");
        }
        if (h_points == null) {
            throw new NullPointerException("h_points");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(vectors);
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)pair.getFirst();
        VocabCache vocab = (VocabCache)pair.getSecond();
        BufferedReader reader = new BufferedReader(new FileReader(hs));
        String line = null;
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            String[] split2 = line.split(" ");
            double[] array = new double[split2.length];
            for (int i2 = 0; i2 < split2.length; ++i2) {
                array[i2] = Double.parseDouble(split2[i2]);
            }
            rows.add(Nd4j.create((double[])array));
        }
        reader.close();
        INDArray syn1 = Nd4j.vstack(rows);
        lookupTable.setSyn1(syn1);
        reader = new BufferedReader(new FileReader(h_points));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            VocabWord word = (VocabWord)vocab.wordFor(split[0]);
            ArrayList<Integer> points = new ArrayList<Integer>();
            for (i = 1; i < split.length; ++i) {
                points.add(Integer.parseInt(split[i]));
            }
            word.setPoints(points);
        }
        reader.close();
        reader = new BufferedReader(new FileReader(h_codes));
        while ((line = reader.readLine()) != null) {
            split = line.split(" ");
            VocabWord word = (VocabWord)vocab.wordFor(split[0]);
            ArrayList<Integer> codes = new ArrayList<Integer>();
            for (i = 1; i < split.length; ++i) {
                codes.add(Integer.parseInt(split[i]));
            }
            word.setCodes(codes);
            word.setCodeLength(codes.size());
        }
        reader.close();
        Word2Vec w2v = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache(vocab)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false).build();
        return w2v;
    }

    public static ParagraphVectors readParagraphVectorsFromText(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        try {
            return WordVectorSerializer.readParagraphVectorsFromText(new FileInputStream(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ParagraphVectors readParagraphVectorsFromText(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            return WordVectorSerializer.readParagraphVectorsFromText(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ParagraphVectors readParagraphVectorsFromText(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<INDArray> arrays = new ArrayList<INDArray>();
            AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(" ");
                split[1] = split[1].replaceAll(whitespaceReplacement, " ");
                VocabWord word = new VocabWord(1.0, split[1]);
                if (split[0].equals("L")) {
                    word.setSpecial(true);
                    word.markAsLabel(true);
                    labels.add(word.getLabel());
                } else if (split[0].equals("E")) {
                    word.setSpecial(false);
                    word.markAsLabel(false);
                } else {
                    throw new IllegalStateException("Source stream doesn't looks like ParagraphVectors serialized model");
                }
                word.setIndex(vocabCache.numWords());
                vocabCache.addToken(word);
                vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
                vocabCache.putVocabWord(word.getLabel());
                float[] vector = new float[split.length - 2];
                for (int i = 2; i < split.length; ++i) {
                    vector[i - 2] = Float.parseFloat(split[i]);
                }
                INDArray row = Nd4j.create((float[])vector);
                arrays.add(row);
            }
            INDArray syn = Nd4j.vstack(arrays);
            InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).useAdaGrad(false).cache(vocabCache).build();
            Nd4j.clearNans((INDArray)syn);
            lookupTable.setSyn0(syn);
            LabelsSource source = new LabelsSource(labels);
            ParagraphVectors vectors = ((ParagraphVectors.Builder)((ParagraphVectors.Builder)((ParagraphVectors.Builder)new ParagraphVectors.Builder().labelsSource(source).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).modelUtils((ModelUtils)new BasicModelUtils())).build();
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return vectors;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull File file) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull String path) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        try (FileOutputStream fos = new FileOutputStream(path);){
            WordVectorSerializer.writeWordVectors(vectors, (OutputStream)fos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(@NonNull Glove vectors, @NonNull OutputStream stream) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try {
            WordVectorSerializer.writeWordVectors(vectors.lookupTable(), stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void writeWordVectors(ParagraphVectors vectors, OutputStream stream) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));){
            VocabCache vocabCache = vectors.getVocab();
            for (VocabWord word : vocabCache.vocabWords()) {
                StringBuilder builder = new StringBuilder();
                builder.append(word.isLabel() ? "L" : "E").append(" ");
                builder.append(word.getLabel().replaceAll(" ", whitespaceReplacement)).append(" ");
                INDArray vector = vectors.getWordVectorMatrix(word.getLabel());
                for (int j = 0; j < vector.length(); ++j) {
                    builder.append(vector.getDouble(j));
                    if (j >= vector.length() - 1) continue;
                    builder.append(" ");
                }
                writer.write(builder.append("\n").toString());
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeWordVectors(InMemoryLookupTable lookupTable, InMemoryLookupCache cache, String path) throws IOException {
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path), false), "UTF-8"));
        for (int i = 0; i < lookupTable.getSyn0().rows(); ++i) {
            String word = cache.wordAtIndex(i);
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(word.replaceAll(" ", whitespaceReplacement));
            sb.append(" ");
            INDArray wordVector = lookupTable.vector(word);
            for (int j = 0; j < wordVector.length(); ++j) {
                sb.append(wordVector.getDouble(j));
                if (j >= wordVector.length() - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
            write.write(sb.toString());
        }
        write.flush();
        write.close();
    }

    private static ObjectMapper getModelMapper() {
        ObjectMapper ret = new ObjectMapper();
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        return ret;
    }

    @Deprecated
    public static void writeFullModel(@NonNull Word2Vec vec, @NonNull String path) {
        int x;
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WeightLookupTable lookupTable = vec.getLookupTable();
        VocabCache vocabCache = vec.getVocab();
        if (!(lookupTable instanceof InMemoryLookupTable)) {
            throw new IllegalStateException("At this moment only InMemoryLookupTable is supported.");
        }
        VectorsConfiguration conf = vec.getConfiguration();
        conf.setVocabSize(vocabCache.numWords());
        printWriter.println(conf.toJson());
        StringBuilder builder = new StringBuilder();
        for (x = 0; x < ((InMemoryLookupTable)lookupTable).getExpTable().length; ++x) {
            builder.append(((InMemoryLookupTable)lookupTable).getExpTable()[x]).append(" ");
        }
        printWriter.println(builder.toString().trim());
        if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getTable() != null) {
            builder = new StringBuilder();
            for (x = 0; x < ((InMemoryLookupTable)lookupTable).getTable().columns(); ++x) {
                builder.append(((InMemoryLookupTable)lookupTable).getTable().getDouble(x)).append(" ");
            }
            printWriter.println(builder.toString().trim());
        } else {
            printWriter.println("");
        }
        ArrayList words = new ArrayList(vocabCache.vocabWords());
        for (SequenceElement word : words) {
            int x2;
            VocabularyWord vw = new VocabularyWord(word.getLabel());
            vw.setCount(vocabCache.wordFrequency(word.getLabel()));
            vw.setHuffmanNode(VocabularyHolder.buildNode(word.getCodes(), word.getPoints(), word.getCodeLength(), word.getIndex()));
            INDArray syn0 = ((InMemoryLookupTable)lookupTable).getSyn0().getRow(vocabCache.indexOf(word.getLabel()));
            double[] dsyn0 = new double[syn0.columns()];
            for (int x3 = 0; x3 < conf.getLayersSize(); ++x3) {
                dsyn0[x3] = syn0.getDouble(x3);
            }
            vw.setSyn0(dsyn0);
            INDArray syn1 = ((InMemoryLookupTable)lookupTable).getSyn1().getRow(vocabCache.indexOf(word.getLabel()));
            double[] dsyn1 = new double[syn1.columns()];
            for (int x4 = 0; x4 < syn1.columns(); ++x4) {
                dsyn1[x4] = syn1.getDouble(x4);
            }
            vw.setSyn1(dsyn1);
            if (conf.getNegative() > 0.0 && ((InMemoryLookupTable)lookupTable).getSyn1Neg() != null) {
                INDArray syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg().getRow(vocabCache.indexOf(word.getLabel()));
                double[] dsyn1Neg = new double[syn1Neg.columns()];
                for (x2 = 0; x2 < syn1Neg.columns(); ++x2) {
                    dsyn1Neg[x2] = syn1Neg.getDouble(x2);
                }
                vw.setSyn1Neg(dsyn1Neg);
            }
            if (conf.isUseAdaGrad() && ((InMemoryLookupTable)lookupTable).isUseAdaGrad()) {
                INDArray gradient = word.getHistoricalGradient();
                if (gradient == null) {
                    gradient = Nd4j.zeros((int)word.getCodes().size());
                }
                double[] ada = new double[gradient.columns()];
                for (x2 = 0; x2 < gradient.columns(); ++x2) {
                    ada[x2] = gradient.getDouble(x2);
                }
                vw.setHistoricalGradient(ada);
            }
            printWriter.println(vw.toJson());
        }
        printWriter.flush();
        printWriter.close();
    }

    @Deprecated
    public static Word2Vec loadFullModel(@NonNull String path) throws FileNotFoundException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        BasicLineIterator iterator = new BasicLineIterator(new File(path));
        String confJson = iterator.nextSentence();
        log.info("Word2Vec conf. JSON: " + confJson);
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(confJson);
        String eTable = iterator.nextSentence();
        String nTable = iterator.nextSentence();
        if (configuration.getNegative() > 0.0) {
            // empty if block
        }
        VocabularyHolder holder = new VocabularyHolder.Builder().minWordFrequency(configuration.getMinWordFrequency()).hugeModelExpected(configuration.isHugeModelExpected()).scavengerActivationThreshold(configuration.getScavengerActivationThreshold()).scavengerRetentionDelay(configuration.getScavengerRetentionDelay()).build();
        AtomicInteger counter = new AtomicInteger(0);
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            word.setSpecial(true);
            VocabWord vw = new VocabWord(word.getCount(), word.getWord());
            vw.setIndex(counter.getAndIncrement());
            vw.setIndex(word.getHuffmanNode().getIdx());
            vw.setCodeLength(word.getHuffmanNode().getLength());
            vw.setPoints(WordVectorSerializer.arrayToList(word.getHuffmanNode().getPoint(), (int)word.getHuffmanNode().getLength()));
            vw.setCodes(WordVectorSerializer.arrayToList(word.getHuffmanNode().getCode(), (int)word.getHuffmanNode().getLength()));
            vocabCache.addToken(vw);
            vocabCache.addWordToIndex(vw.getIndex(), vw.getLabel());
            vocabCache.putVocabWord(vw.getWord());
        }
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder().negative(configuration.getNegative()).useAdaGrad(configuration.isUseAdaGrad()).lr(configuration.getLearningRate()).cache(vocabCache).vectorLength(configuration.getLayersSize()).build();
        lookupTable.resetWeights(true);
        iterator.reset();
        iterator.nextSentence();
        iterator.nextSentence();
        iterator.nextSentence();
        while (iterator.hasNext()) {
            String wordJson = iterator.nextSentence();
            VocabularyWord word = VocabularyWord.fromJson(wordJson);
            INDArray syn0 = lookupTable.getSyn0().getRow(vocabCache.indexOf(word.getWord()));
            syn0.assign(Nd4j.create((double[])word.getSyn0()));
            INDArray syn1 = lookupTable.getSyn1().getRow(vocabCache.indexOf(word.getWord()));
            syn1.assign(Nd4j.create((double[])word.getSyn1()));
            if (!(configuration.getNegative() > 0.0)) continue;
            INDArray syn1Neg = lookupTable.getSyn1Neg().getRow(vocabCache.indexOf(word.getWord()));
            syn1Neg.assign(Nd4j.create((double[])word.getSyn1Neg()));
        }
        Word2Vec vec = ((Word2Vec.Builder)((Word2Vec.Builder)new Word2Vec.Builder(configuration).vocabCache((VocabCache)vocabCache)).lookupTable((WeightLookupTable)lookupTable)).resetModel(false).build();
        vec.setModelUtils(new BasicModelUtils());
        return vec;
    }

    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull String path) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(path), false), "UTF-8"));
        WordVectorSerializer.writeWordVectors(vec, write);
        write.flush();
        write.close();
    }

    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull File file) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        WordVectorSerializer.writeWordVectors(vec, write);
        write.flush();
        write.close();
    }

    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull OutputStream outputStream) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        WordVectorSerializer.writeWordVectors(vec, writer);
        writer.flush();
        writer.close();
    }

    public static void writeWordVectors(@NonNull Word2Vec vec, @NonNull BufferedWriter writer) throws IOException {
        if (vec == null) {
            throw new NullPointerException("vec");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        int words = 0;
        for (String word : vec.vocab().words()) {
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(word.replaceAll(" ", whitespaceReplacement));
            sb.append(" ");
            INDArray wordVector = vec.getWordVectorMatrix(word);
            for (int j = 0; j < wordVector.length(); ++j) {
                sb.append(wordVector.getDouble(j));
                if (j >= wordVector.length() - 1) continue;
                sb.append(" ");
            }
            sb.append("\n");
            writer.write(sb.toString());
            ++words;
        }
        try {
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
    }

    public static WordVectors fromTableAndVocab(WeightLookupTable table, VocabCache vocab) {
        WordVectorsImpl vectors = new WordVectorsImpl();
        vectors.setLookupTable(table);
        vectors.setVocab(vocab);
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    public static WordVectors fromPair(Pair<InMemoryLookupTable, VocabCache> pair) {
        WordVectorsImpl vectors = new WordVectorsImpl();
        vectors.setLookupTable((WeightLookupTable)pair.getFirst());
        vectors.setVocab((VocabCache)pair.getSecond());
        vectors.setModelUtils(new BasicModelUtils());
        return vectors;
    }

    public static WordVectors loadTxtVectors(File vectorsFile) throws FileNotFoundException, UnsupportedEncodingException {
        Pair<InMemoryLookupTable, VocabCache> pair = WordVectorSerializer.loadTxt(vectorsFile);
        return WordVectorSerializer.fromPair(pair);
    }

    public static Pair<InMemoryLookupTable, VocabCache> loadTxt(File vectorsFile) throws FileNotFoundException, UnsupportedEncodingException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vectorsFile), "UTF-8"));
        AbstractCache<VocabWord> cache = new AbstractCache<VocabWord>();
        LineIterator iter = IOUtils.lineIterator((Reader)reader);
        String line = null;
        boolean hasHeader = false;
        if (iter.hasNext()) {
            line = iter.nextLine();
            if (!line.contains(" ")) {
                log.info("Skipping first line");
                hasHeader = true;
            } else {
                String[] split = line.split(" ");
                try {
                    for (int x = 1; x < split.length; ++x) {
                        double d = Double.parseDouble(split[x]);
                    }
                    if (split.length < 4) {
                        hasHeader = true;
                    }
                }
                catch (Exception e) {
                    hasHeader = true;
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (hasHeader) {
            line = "";
            iter.close();
            reader = new BufferedReader(new FileReader(vectorsFile));
            iter = IOUtils.lineIterator((Reader)reader);
            iter.nextLine();
        }
        ArrayList<INDArray> arrays = new ArrayList<INDArray>();
        while (iter.hasNext()) {
            if (line.isEmpty()) {
                line = iter.nextLine();
            }
            String[] split = line.split(" ");
            String word = split[0].replaceAll(whitespaceReplacement, " ");
            VocabWord word1 = new VocabWord(1.0, word);
            word1.setIndex(cache.numWords());
            cache.addToken(word1);
            cache.addWordToIndex(word1.getIndex(), word);
            cache.putVocabWord(word);
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            INDArray row = Nd4j.create((float[])vector);
            arrays.add(row);
            line = "";
        }
        INDArray syn = Nd4j.vstack(arrays);
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).useAdaGrad(false).cache(cache).build();
        Nd4j.clearNans((INDArray)syn);
        lookupTable.setSyn0(syn);
        iter.close();
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Pair((Object)lookupTable, cache);
    }

    public static WordVectors loadTxtVectors(@NonNull InputStream stream, boolean skipFirstLine) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        AbstractCache<VocabWord> cache = new AbstractCache.Builder().build();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        ArrayList<INDArray> arrays = new ArrayList<INDArray>();
        if (skipFirstLine) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(" ");
            String word = split[0].replaceAll(whitespaceReplacement, " ");
            VocabWord word1 = new VocabWord(1.0, word);
            word1.setIndex(cache.numWords());
            cache.addToken(word1);
            cache.addWordToIndex(word1.getIndex(), word);
            cache.putVocabWord(word);
            float[] vector = new float[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                vector[i - 1] = Float.parseFloat(split[i]);
            }
            INDArray row = Nd4j.create((float[])vector);
            arrays.add(row);
        }
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder().vectorLength(((INDArray)arrays.get(0)).columns()).cache(cache).build();
        INDArray syn = Nd4j.vstack(arrays);
        Nd4j.clearNans((INDArray)syn);
        lookupTable.setSyn0(syn);
        return WordVectorSerializer.fromPair((Pair<InMemoryLookupTable, VocabCache>)Pair.makePair((Object)lookupTable, cache));
    }

    public static void writeTsneFormat(Glove vec, INDArray tsne, File csv) throws Exception {
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv), "UTF-8"));
        int words = 0;
        InMemoryLookupCache l = (InMemoryLookupCache)vec.vocab();
        for (String word : vec.vocab().words()) {
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            INDArray wordVector = tsne.getRow(l.wordFor(word).getIndex());
            for (int j = 0; j < wordVector.length(); ++j) {
                sb.append(wordVector.getDouble(j));
                if (j >= wordVector.length() - 1) continue;
                sb.append(",");
            }
            sb.append(",");
            sb.append(word.replaceAll(" ", whitespaceReplacement));
            sb.append(" ");
            sb.append("\n");
            write.write(sb.toString());
        }
        log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
        write.flush();
        write.close();
    }

    public static void writeTsneFormat(Word2Vec vec, INDArray tsne, File csv) throws Exception {
        BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csv), "UTF-8"));
        int words = 0;
        InMemoryLookupCache l = (InMemoryLookupCache)vec.vocab();
        for (String word : vec.vocab().words()) {
            if (word == null) continue;
            StringBuilder sb = new StringBuilder();
            INDArray wordVector = tsne.getRow(l.wordFor(word).getIndex());
            for (int j = 0; j < wordVector.length(); ++j) {
                sb.append(wordVector.getDouble(j));
                if (j >= wordVector.length() - 1) continue;
                sb.append(",");
            }
            sb.append(",");
            sb.append(word.replaceAll(" ", whitespaceReplacement));
            sb.append(" ");
            sb.append("\n");
            write.write(sb.toString());
        }
        log.info("Wrote " + words + " with size of " + vec.lookupTable().layerSize());
        write.flush();
        write.close();
    }

    private static List<Integer> arrayToList(byte[] array, int codeLen) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(Integer.valueOf(array[x]));
        }
        return result;
    }

    private static byte[] listToArray(List<Integer> code) {
        byte[] array = new byte[40];
        for (int x = 0; x < code.size(); ++x) {
            array[x] = code.get(x).byteValue();
        }
        return array;
    }

    private static int[] listToArray(List<Integer> points, int codeLen) {
        int[] array = new int[points.size()];
        for (int x = 0; x < points.size(); ++x) {
            array[x] = points.get(x);
        }
        return array;
    }

    private static List<Integer> arrayToList(int[] array, int codeLen) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < codeLen; ++x) {
            result.add(array[x]);
        }
        return result;
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull String path) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        WordVectorSerializer.writeSequenceVectors(vectors, factory, new FileOutputStream(path));
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        WordVectorSerializer.writeSequenceVectors(vectors, factory, new FileOutputStream(file));
    }

    public static <T extends SequenceElement> void writeSequenceVectors(@NonNull SequenceVectors<T> vectors, @NonNull SequenceElementFactory<T> factory, @NonNull OutputStream stream) throws IOException {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        WeightLookupTable lookupTable = vectors.getLookupTable();
        VocabCache vocabCache = vectors.getVocab();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        writer.write(vectors.getConfiguration().toEncodedJson());
        for (int x = 0; x < vocabCache.numWords(); ++x) {
            Object element = vocabCache.elementAtIndex(x);
            String json = factory.serialize(element);
            double[] vector = lookupTable.vector(((SequenceElement)element).getLabel()).data().asDouble();
            ElementPair pair = new ElementPair(json, vector);
            writer.println(pair.toEncodedJson());
        }
        writer.flush();
        writer.close();
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull File file) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        return WordVectorSerializer.readSequenceVectors(factory, new FileInputStream(file));
    }

    public static <T extends SequenceElement> SequenceVectors<T> readSequenceVectors(@NonNull SequenceElementFactory<T> factory, @NonNull InputStream stream) throws IOException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        String line = reader.readLine();
        VectorsConfiguration configuration = VectorsConfiguration.fromJson(new String(Base64.decodeBase64((String)line), "UTF-8"));
        AbstractCache<T> vocabCache = new AbstractCache.Builder().build();
        ArrayList<INDArray> rows = new ArrayList<INDArray>();
        while ((line = reader.readLine()) != null) {
            ElementPair pair = ElementPair.fromEncodedJson(line);
            T element = factory.deserialize(pair.getObject());
            rows.add(Nd4j.create((double[])pair.getVector()));
            vocabCache.addToken(element);
            vocabCache.addWordToIndex(((SequenceElement)element).getIndex(), ((SequenceElement)element).getLabel());
        }
        reader.close();
        InMemoryLookupTable lookupTable = (InMemoryLookupTable)new InMemoryLookupTable.Builder().vectorLength(((INDArray)rows.get(0)).columns()).build();
        INDArray syn0 = Nd4j.vstack(rows);
        lookupTable.setSyn0(syn0);
        SequenceVectors vectors = new SequenceVectors.Builder<T>(configuration).vocabCache(vocabCache).lookupTable(lookupTable).resetModel(false).build();
        return vectors;
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull File file) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        WordVectorSerializer.writeVocabCache(vocabCache, new FileOutputStream(file));
    }

    public static void writeVocabCache(@NonNull VocabCache<VocabWord> vocabCache, @NonNull OutputStream stream) throws IOException {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(stream, "UTF-8")));
        for (int x = 0; x < vocabCache.numWords(); ++x) {
            VocabWord word = vocabCache.elementAtIndex(x);
            writer.println(word.toJSON());
        }
        writer.flush();
        writer.close();
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return WordVectorSerializer.readVocabCache(new FileInputStream(file));
    }

    public static VocabCache<VocabWord> readVocabCache(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        AbstractCache<VocabWord> vocabCache = new AbstractCache.Builder().build();
        VocabWordFactory factory = new VocabWordFactory();
        String line = "";
        while ((line = reader.readLine()) != null) {
            VocabWord word = factory.deserialize(line);
            vocabCache.addToken(word);
            vocabCache.addWordToIndex(word.getIndex(), word.getLabel());
        }
        return vocabCache;
    }

    private static class ElementPair {
        private String object;
        private double[] vector;

        protected String toEncodedJson() {
            ObjectMapper mapper = SequenceElement.mapper();
            Base64 base64 = new Base64(Integer.MAX_VALUE);
            try {
                String json = mapper.writeValueAsString((Object)this);
                String output = base64.encodeAsString(json.getBytes("UTF-8"));
                return output;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected static ElementPair fromEncodedJson(String encoded) {
            ObjectMapper mapper = SequenceElement.mapper();
            try {
                String decoded = new String(Base64.decodeBase64((String)encoded), "UTF-8");
                return (ElementPair)mapper.readValue(decoded, ElementPair.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getObject() {
            return this.object;
        }

        public double[] getVector() {
            return this.vector;
        }

        public void setObject(String object) {
            this.object = object;
        }

        public void setVector(double[] vector) {
            this.vector = vector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementPair)) {
                return false;
            }
            ElementPair other = (ElementPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            return Arrays.equals(this.getVector(), other.getVector());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElementPair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 0 : $object.hashCode());
            result = result * 59 + Arrays.hashCode(this.getVector());
            return result;
        }

        public String toString() {
            return "WordVectorSerializer.ElementPair(object=" + this.getObject() + ", vector=" + Arrays.toString(this.getVector()) + ")";
        }

        public ElementPair() {
        }

        @ConstructorProperties(value={"object", "vector"})
        public ElementPair(String object, double[] vector) {
            this.object = object;
            this.vector = vector;
        }
    }
}

