/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.CBOW;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class DM<T extends SequenceElement>
implements SequenceLearningAlgorithm<T> {
    private VocabCache<T> vocabCache;
    private WeightLookupTable<T> lookupTable;
    private VectorsConfiguration configuration;
    protected static double MAX_EXP = 6.0;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected double sampling;
    protected double[] expTable;
    protected INDArray syn0;
    protected INDArray syn1;
    protected INDArray syn1Neg;
    protected INDArray table;
    private CBOW<T> cbow = new CBOW();

    @Override
    public String getCodeName() {
        return "PV-DM";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.cbow.configure(vocabCache, lookupTable, configuration);
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
        this.syn0 = ((InMemoryLookupTable)lookupTable).getSyn0();
        this.syn1 = ((InMemoryLookupTable)lookupTable).getSyn1();
        this.syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg();
        this.expTable = ((InMemoryLookupTable)lookupTable).getExpTable();
        this.table = ((InMemoryLookupTable)lookupTable).getTable();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    @Override
    public double learnSequence(Sequence<T> sequence, AtomicLong nextRandom, double learningRate) {
        Sequence<T> seq = this.cbow.applySubsampling(sequence, nextRandom);
        ArrayList<T> labels = new ArrayList<T>();
        labels.addAll(sequence.getSequenceLabels());
        if (sequence.getSequenceLabel() == null) {
            throw new IllegalStateException("Label is NULL");
        }
        if (seq.isEmpty() || labels.isEmpty()) {
            return 0.0;
        }
        ArrayList<INDArray> labelArrays = new ArrayList<INDArray>();
        for (SequenceElement label : labels) {
            labelArrays.add(this.syn0.getRow(label.getIndex()));
        }
        for (int i = 0; i < seq.size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.dm(i, seq, (int)nextRandom.get() % this.window, nextRandom, learningRate, labelArrays, false);
        }
        return 0.0;
    }

    public void dm(int i, Sequence<T> sequence, int b, AtomicLong nextRandom, double alpha, List<INDArray> labels, boolean isInference) {
        int end = this.window * 2 + 1 - b;
        int cw = 0;
        INDArray neu1 = Nd4j.zeros((int)this.lookupTable.layerSize());
        T currentWord = sequence.getElementByIndex(i);
        for (int a = b; a < end; ++a) {
            int c;
            if (a == this.window || (c = i - this.window + a) < 0 || c >= sequence.size()) continue;
            T lastWord = sequence.getElementByIndex(c);
            neu1.addiRowVector(this.syn0.getRow(((SequenceElement)lastWord).getIndex()));
            ++cw;
        }
        for (INDArray label : labels) {
            neu1.addiRowVector(label);
            ++cw;
        }
        if (cw == 0) {
            return;
        }
        neu1.divi((Number)cw);
        INDArray neu1e = this.cbow.iterateSample(currentWord, neu1, nextRandom, alpha, isInference);
        for (INDArray label : labels) {
            Nd4j.getBlasWrapper().level1().axpy(this.lookupTable.layerSize(), 1.0, neu1e, label);
        }
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    @Override
    public INDArray inferSequence(Sequence<T> sequence, long nr, double learningRate) {
        AtomicLong nextRandom = new AtomicLong(nr);
        if (sequence.isEmpty()) {
            return null;
        }
        ArrayList<INDArray> labelArrays = new ArrayList<INDArray>();
        INDArray ret = Nd4j.rand((long)nr, (int[])new int[]{1, this.lookupTable.layerSize()}).subi((Number)0.5).divi((Number)this.lookupTable.layerSize());
        labelArrays.add(ret);
        for (int iter = 0; iter < this.configuration.getIterations(); ++iter) {
            for (int i = 0; i < sequence.size(); ++i) {
                nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                this.dm(i, sequence, (int)nextRandom.get() % this.window, nextRandom, learningRate, labelArrays, true);
            }
        }
        return ret;
    }
}

