/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;

public class NGramTokenizer
implements Tokenizer {
    private List<String> tokens = new ArrayList<String>();
    private List<String> originalTokens;
    private int index;
    private TokenPreProcess preProcess;
    private Tokenizer tokenizer;

    public NGramTokenizer(Tokenizer tokenizer, Integer minN, Integer maxN) {
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            this.tokens.add(nextToken);
        }
        if (maxN != 1) {
            this.originalTokens = this.tokens;
            this.tokens = new ArrayList<String>();
            Integer nOriginalTokens = this.originalTokens.size();
            Integer min = Math.min(maxN + 1, nOriginalTokens + 1);
            for (int i = minN.intValue(); i < min; ++i) {
                for (int j = 0; j < nOriginalTokens - i + 1; ++j) {
                    List<String> originalTokensSlice = this.originalTokens.subList(j, j + i);
                    this.tokens.add(StringUtils.join((Object[])new Object[]{" ", originalTokensSlice}));
                }
            }
        }
    }

    @Override
    public boolean hasMoreTokens() {
        return this.index < this.tokens.size();
    }

    @Override
    public int countTokens() {
        return this.tokens.size();
    }

    @Override
    public String nextToken() {
        String ret = this.tokens.get(this.index);
        ++this.index;
        return ret;
    }

    @Override
    public List<String> getTokens() {
        ArrayList<String> tokens = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            tokens.add(this.nextToken());
        }
        return tokens;
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
        this.preProcess = tokenPreProcessor;
    }
}

