/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.movingwindow;

import java.util.List;
import org.deeplearning4j.models.word2vec.Word2Vec;
import org.deeplearning4j.text.movingwindow.Window;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class WindowConverter {
    public static INDArray asExampleArray(Window window, Word2Vec vec, boolean normalize) {
        int length = vec.lookupTable().layerSize();
        List<String> words = window.getWords();
        int windowSize = vec.getWindow();
        assert (words.size() == vec.getWindow());
        INDArray ret = Nd4j.create((int)(length * windowSize));
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            INDArray n = normalize ? vec.getWordVectorMatrixNormalized(word) : vec.getWordVectorMatrix(word);
            ret.put(new INDArrayIndex[]{NDArrayIndex.interval((int)(i * vec.lookupTable().layerSize()), (int)(i * vec.lookupTable().layerSize() + vec.lookupTable().layerSize()))}, n);
        }
        return ret;
    }

    public static INDArray asExampleMatrix(Window window, Word2Vec vec) {
        INDArray[] data = new INDArray[window.getWords().size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = vec.getWordVectorMatrix(window.getWord(i));
        }
        return Nd4j.hstack((INDArray[])data);
    }
}

