/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator.interoperability;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareDocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;

public class DocumentIteratorConverter
implements LabelAwareIterator {
    protected DocumentIterator backendIterator;
    protected LabelsSource generator;

    public DocumentIteratorConverter(@NonNull LabelAwareDocumentIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.backendIterator = iterator;
    }

    public DocumentIteratorConverter(@NonNull DocumentIterator iterator, @NonNull LabelsSource generator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (generator == null) {
            throw new NullPointerException("generator");
        }
        this.backendIterator = iterator;
        this.generator = generator;
    }

    @Override
    public boolean hasNextDocument() {
        return this.backendIterator.hasNext();
    }

    @Override
    public LabelledDocument nextDocument() {
        try {
            LabelledDocument document = new LabelledDocument();
            document.setContent(this.readStream(this.backendIterator.nextDocument()));
            if (this.backendIterator instanceof LabelAwareDocumentIterator) {
                String currentLabel = ((LabelAwareDocumentIterator)this.backendIterator).currentLabel();
                document.setLabel(currentLabel);
                this.generator.storeLabel(currentLabel);
            } else {
                document.setLabel(this.generator.nextLabel());
            }
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() {
        this.generator.reset();
        this.backendIterator.reset();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.generator;
    }

    protected String readStream(InputStream stream) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = "";
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        return builder.toString();
    }
}

