/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Huffman {
    public final int MAX_CODE_LENGTH;
    private volatile boolean buildTrigger = false;
    private Logger logger = LoggerFactory.getLogger(Huffman.class);
    private List<? extends SequenceElement> words;

    public Huffman(Collection<? extends SequenceElement> words) {
        this(words, 40);
    }

    public Huffman(Collection<? extends SequenceElement> words, int CODE_LENGTH) {
        this.MAX_CODE_LENGTH = CODE_LENGTH;
        this.words = new ArrayList<SequenceElement>(words);
        Collections.sort(this.words, new Comparator<SequenceElement>(){

            @Override
            public int compare(SequenceElement o1, SequenceElement o2) {
                return Double.compare(o2.getElementFrequency(), o1.getElementFrequency());
            }
        });
    }

    public void build() {
        int a;
        this.buildTrigger = true;
        long[] count = new long[this.words.size() * 2 + 1];
        int[] binary = new int[this.words.size() * 2 + 1];
        int[] code = new int[this.MAX_CODE_LENGTH];
        int[] point = new int[this.MAX_CODE_LENGTH];
        int[] parentNode = new int[this.words.size() * 2 + 1];
        for (a = 0; a < this.words.size(); ++a) {
            count[a] = (long)this.words.get(a).getElementFrequency();
        }
        for (a = this.words.size(); a < this.words.size() * 2; ++a) {
            count[a] = Integer.MAX_VALUE;
        }
        int pos1 = this.words.size() - 1;
        int pos2 = this.words.size();
        a = 0;
        for (a = 0; a < this.words.size() - 1; ++a) {
            int min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            int min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            count[this.words.size() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.words.size() + a;
            parentNode[min2i] = this.words.size() + a;
            binary[min2i] = 1;
        }
        for (a = 0; a < this.words.size(); ++a) {
            int b = a;
            int i = 0;
            do {
                code[i] = binary[b];
                point[i] = b;
            } while ((b = parentNode[b]) != this.words.size() * 2 - 2 && ++i < 39);
            this.words.get(a).setCodeLength(i);
            this.words.get(a).getPoints().add(this.words.size() - 2);
            for (b = 0; b < i; ++b) {
                try {
                    this.words.get(a).getCodes().set(i - b - 1, code[b]);
                    this.words.get(a).getPoints().set(i - b, point[b] - this.words.size());
                    continue;
                }
                catch (Exception e) {
                    this.logger.info("Words size: [" + this.words.size() + "], a: [" + a + "], b: [" + b + "], i: [" + i + "], points size: [" + this.words.get(a).getPoints().size() + "]");
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void applyIndexes(VocabCache<? extends SequenceElement> cache) {
        if (!this.buildTrigger) {
            this.build();
        }
        for (int a = 0; a < this.words.size(); ++a) {
            cache.addWordToIndex(a, this.words.get(a).getLabel());
            this.words.get(a).setIndex(a);
        }
    }
}

