/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.transformers.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.transformers.SequenceTransformer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.documentiterator.BasicLabelAwareIterator;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceTransformer
implements SequenceTransformer<VocabWord, String>,
Iterable<Sequence<VocabWord>> {
    protected TokenizerFactory tokenizerFactory;
    protected LabelAwareIterator iterator;
    protected boolean readOnly = false;
    protected AtomicInteger sentenceCounter = new AtomicInteger(0);
    protected static final Logger log = LoggerFactory.getLogger(SentenceTransformer.class);

    private SentenceTransformer(@NonNull LabelAwareIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.iterator = iterator;
    }

    @Override
    public Sequence<VocabWord> transformToSequence(String object) {
        Sequence<VocabWord> sequence = new Sequence<VocabWord>();
        Tokenizer tokenizer = this.tokenizerFactory.create(object);
        List<String> list = tokenizer.getTokens();
        for (String token : list) {
            if (token == null || token.isEmpty() || token.trim().isEmpty()) continue;
            VocabWord word = new VocabWord(1.0, token);
            sequence.addElement(word);
        }
        sequence.setSequenceId(this.sentenceCounter.getAndIncrement());
        return sequence;
    }

    @Override
    public Iterator<Sequence<VocabWord>> iterator() {
        this.iterator.reset();
        return new Iterator<Sequence<VocabWord>>(){

            @Override
            public boolean hasNext() {
                return SentenceTransformer.this.iterator.hasNextDocument();
            }

            @Override
            public Sequence<VocabWord> next() {
                LabelledDocument document = SentenceTransformer.this.iterator.nextDocument();
                if (document.getContent() == null) {
                    return new Sequence<VocabWord>();
                }
                Sequence<VocabWord> sequence = SentenceTransformer.this.transformToSequence(document.getContent());
                if (document.getLabel() != null && !document.getLabel().isEmpty()) {
                    sequence.setSequenceLabel(new VocabWord(1.0, document.getLabel()));
                }
                return sequence;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class Builder {
        protected TokenizerFactory tokenizerFactory;
        protected LabelAwareIterator iterator;
        protected VocabCache<VocabWord> vocabCache;
        protected boolean readOnly = false;

        public Builder tokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        public Builder iterator(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = iterator;
            return this;
        }

        public Builder iterator(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = new BasicLabelAwareIterator.Builder(iterator).build();
            return this;
        }

        public Builder iterator(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.iterator = new BasicLabelAwareIterator.Builder(iterator).build();
            return this;
        }

        public Builder readOnly(boolean readOnly) {
            this.readOnly = true;
            return this;
        }

        public SentenceTransformer build() {
            SentenceTransformer transformer = new SentenceTransformer(this.iterator);
            transformer.tokenizerFactory = this.tokenizerFactory;
            transformer.readOnly = this.readOnly;
            return transformer;
        }
    }
}

