/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.glove.count;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RoundCount {
    private int limit = 0;
    private int lower = 0;
    private int value = 0;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public RoundCount(int limit) {
        this.limit = limit;
    }

    public RoundCount(int lower, int top) {
        this.limit = top;
        this.lower = lower;
    }

    public int previous() {
        try {
            this.lock.readLock().lock();
            if (this.value == this.lower) {
                int n = this.limit;
                return n;
            }
            int n = this.value - 1;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int get() {
        try {
            this.lock.readLock().lock();
            int n = this.value;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void tick() {
        try {
            this.lock.writeLock().lock();
            this.value = this.value == this.limit ? this.lower : ++this.value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

