/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.elements;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.inmemory.InMemoryLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class SkipGram<T extends SequenceElement>
implements ElementsLearningAlgorithm<T> {
    protected VocabCache<T> vocabCache;
    protected WeightLookupTable<T> lookupTable;
    protected VectorsConfiguration configuration;
    protected static double MAX_EXP = 6.0;
    protected double[] expTable;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected INDArray syn0;
    protected INDArray syn1;
    protected INDArray syn1Neg;
    protected INDArray table;
    protected double sampling;

    @Override
    public String getCodeName() {
        return "SkipGram";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.configuration = configuration;
        this.expTable = ((InMemoryLookupTable)lookupTable).getExpTable();
        this.syn0 = ((InMemoryLookupTable)lookupTable).getSyn0();
        this.syn1 = ((InMemoryLookupTable)lookupTable).getSyn1();
        this.syn1Neg = ((InMemoryLookupTable)lookupTable).getSyn1Neg();
        this.table = ((InMemoryLookupTable)lookupTable).getTable();
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.sampling = configuration.getSampling();
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    protected Sequence<T> applySubsampling(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> result = new Sequence<T>();
        if (this.sampling > 0.0) {
            result.setSequenceId(sequence.getSequenceId());
            if (sequence.getSequenceLabels() != null) {
                result.setSequenceLabels(sequence.getSequenceLabels());
            }
            if (sequence.getSequenceLabel() != null) {
                result.setSequenceLabel(sequence.getSequenceLabel());
            }
            for (SequenceElement element : sequence.getElements()) {
                double numWords = this.vocabCache.totalWordOccurrences();
                double ran = (Math.sqrt(element.getElementFrequency() / (this.sampling * numWords)) + 1.0) * (this.sampling * numWords) / element.getElementFrequency();
                nextRandom.set(nextRandom.get() * 25214903917L + 11L);
                if (ran < (double)(nextRandom.get() & 0xFFFFL) / 65536.0) continue;
                result.addElement(element);
            }
            return result;
        }
        return sequence;
    }

    @Override
    public void learnSequence(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom, @NonNull double learningRate) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        Sequence<T> tempSequence = sequence;
        if (this.sampling > 0.0) {
            tempSequence = this.applySubsampling(sequence, nextRandom);
        }
        for (int i = 0; i < tempSequence.getElements().size(); ++i) {
            nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
            this.skipGram(i, tempSequence.getElements(), (int)nextRandom.get() % this.window, nextRandom, learningRate);
        }
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    private void skipGram(int i, List<T> sentence, int b, AtomicLong nextRandom, double alpha) {
        SequenceElement word = (SequenceElement)sentence.get(i);
        if (word == null || sentence.isEmpty()) {
            return;
        }
        int end = this.window * 2 + 1 - b;
        for (int a = b; a < end; ++a) {
            int c;
            if (a == this.window || (c = i - this.window + a) < 0 || c >= sentence.size()) continue;
            SequenceElement lastWord = (SequenceElement)sentence.get(c);
            this.iterateSample(word, lastWord, nextRandom, alpha);
        }
    }

    public void iterateSample(T w1, T w2, AtomicLong nextRandom, double alpha) {
        INDArray neu1e;
        INDArray l1;
        block15: {
            if (w1 == null || w2 == null || ((SequenceElement)w2).getIndex() < 0 || ((SequenceElement)w1).getIndex() == ((SequenceElement)w2).getIndex() || ((SequenceElement)w1).getLabel().equals("STOP") || ((SequenceElement)w2).getLabel().equals("STOP") || ((SequenceElement)w1).getLabel().equals("UNK") || ((SequenceElement)w2).getLabel().equals("UNK")) {
                return;
            }
            l1 = this.syn0.slice(((SequenceElement)w2).getIndex());
            neu1e = Nd4j.create((int)this.configuration.getLayersSize());
            for (int i = 0; i < ((SequenceElement)w1).getCodeLength(); ++i) {
                double g;
                int idx;
                int code = ((SequenceElement)w1).getCodes().get(i);
                int point = ((SequenceElement)w1).getPoints().get(i);
                if (point >= this.syn0.rows() || point < 0) {
                    throw new IllegalStateException("Illegal point " + point);
                }
                INDArray syn1 = this.syn1.slice(point);
                double dot = Nd4j.getBlasWrapper().dot(l1, syn1);
                if (dot < -MAX_EXP || dot >= MAX_EXP || (idx = (int)((dot + MAX_EXP) * ((double)this.expTable.length / MAX_EXP / 2.0))) >= this.expTable.length) continue;
                double f = this.expTable[idx];
                double d = g = this.useAdaGrad ? ((SequenceElement)w1).getGradient(i, (double)(1 - code) - f, alpha) : ((double)(1 - code) - f) * alpha;
                if (neu1e.data().dataType() == DataBuffer.Type.FLOAT) {
                    Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, syn1, neu1e);
                    Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, l1, syn1);
                    continue;
                }
                Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, syn1, neu1e);
                Nd4j.getBlasWrapper().level1().axpy(syn1.length(), g, l1, syn1);
            }
            int target = ((SequenceElement)w1).getIndex();
            if (!(this.negative > 0.0)) break block15;
            int d = 0;
            while ((double)d < this.negative + 1.0) {
                block18: {
                    double g;
                    block20: {
                        double f;
                        int label;
                        block21: {
                            block19: {
                                block17: {
                                    block16: {
                                        if (d != 0) break block16;
                                        label = 1;
                                        break block17;
                                    }
                                    nextRandom.set(Math.abs(nextRandom.get() * 25214903917L + 11L));
                                    int idx = Math.abs((int)(nextRandom.get() >> 16) % this.table.length());
                                    target = this.table.getInt(new int[]{idx});
                                    if (target <= 0) {
                                        target = (int)nextRandom.get() % (this.vocabCache.numWords() - 1) + 1;
                                    }
                                    if (target == ((SequenceElement)w1).getIndex()) break block18;
                                    label = 0;
                                }
                                if (target >= this.syn1Neg.rows() || target < 0) break block18;
                                f = Nd4j.getBlasWrapper().dot(l1, this.syn1Neg.slice(target));
                                if (!(f > MAX_EXP)) break block19;
                                g = this.useAdaGrad ? this.lookupTable.getGradient(target, label - 1) : (double)(label - 1) * alpha;
                                break block20;
                            }
                            if (!(f < -MAX_EXP)) break block21;
                            g = (double)label * (this.useAdaGrad ? this.lookupTable.getGradient(target, alpha) : alpha);
                            break block20;
                        }
                        int idx = (int)((f + MAX_EXP) * ((double)this.expTable.length / MAX_EXP / 2.0));
                        if (idx >= this.expTable.length) break block18;
                        double d2 = g = this.useAdaGrad ? this.lookupTable.getGradient(target, (double)label - this.expTable[idx]) : ((double)label - this.expTable[idx]) * alpha;
                    }
                    if (this.syn0.data().dataType() == DataBuffer.Type.DOUBLE) {
                        Nd4j.getBlasWrapper().axpy(g, this.syn1Neg.slice(target), neu1e);
                    } else {
                        Nd4j.getBlasWrapper().axpy((float)g, this.syn1Neg.slice(target), neu1e);
                    }
                    if (this.syn0.data().dataType() == DataBuffer.Type.DOUBLE) {
                        Nd4j.getBlasWrapper().axpy(g, l1, this.syn1Neg.slice(target));
                    } else {
                        Nd4j.getBlasWrapper().axpy((float)g, l1, this.syn1Neg.slice(target));
                    }
                }
                ++d;
            }
        }
        if (this.syn0.data().dataType() == DataBuffer.Type.DOUBLE) {
            Nd4j.getBlasWrapper().axpy(1.0, neu1e, l1);
        } else {
            Nd4j.getBlasWrapper().axpy(1.0f, neu1e, l1);
        }
    }
}

