/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class VocabWord
extends SequenceElement
implements Serializable {
    private static final long serialVersionUID = 2223750736522624256L;
    private String word;
    protected Long vocabId;
    protected Long affinityId;

    public static VocabWord none() {
        return new VocabWord(0.0, "none");
    }

    public VocabWord(double wordFrequency, String word) {
        if (word == null || word.isEmpty()) {
            throw new IllegalArgumentException("Word must not be null or empty");
        }
        this.word = word;
        this.elementFrequency.set(wordFrequency);
    }

    public VocabWord() {
    }

    @Override
    public String getLabel() {
        return this.word;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        VocabWord vocabWord = (VocabWord)o;
        return this.word.equals(vocabWord.getWord());
    }

    @Override
    public int hashCode() {
        int result = this.word == null ? 0 : this.word.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "VocabWord{wordFrequency=" + this.elementFrequency + ", index=" + this.index + ", codes=" + this.codes + ", word='" + this.word + '\'' + ", historicalGradient=" + this.historicalGradient + ", points=" + this.points + ", codeLength=" + this.codeLength + '}';
    }

    @Override
    public String toJSON() {
        ObjectMapper mapper = VocabWord.mapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getVocabId() {
        return this.vocabId;
    }

    public void setVocabId(Long vocabId) {
        this.vocabId = vocabId;
    }

    public Long getAffinityId() {
        return this.affinityId;
    }

    public void setAffinityId(Long affinityId) {
        this.affinityId = affinityId;
    }
}

