/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.primitives;

import java.beans.ConstructorProperties;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class Vertex<T extends SequenceElement> {
    private final int idx;
    private T value;

    public int vertexID() {
        return this.idx;
    }

    public String toString() {
        return "vertex(" + this.idx + "," + (this.value != null ? this.value : "") + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex v = (Vertex)o;
        if (this.idx != v.idx) {
            return false;
        }
        if (this.value == null && v.value != null || this.value != null && v.value == null) {
            return false;
        }
        return this.value == null || ((SequenceElement)this.value).equals(v.value);
    }

    @ConstructorProperties(value={"idx", "value"})
    public Vertex(int idx, T value) {
        this.idx = idx;
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }
}

