/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.treeparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.StringUtils;
import org.deeplearning4j.models.featuredetectors.autoencoder.recursive.Tree;
import org.deeplearning4j.text.corpora.treeparser.transformer.TreeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarizeTreeTransformer
implements TreeTransformer {
    private String factor = "left";
    private int horizontonalMarkov = 999;
    private static Logger log = LoggerFactory.getLogger(BinarizeTreeTransformer.class);

    @Override
    public Tree transform(Tree t) {
        if (t == null) {
            return null;
        }
        Stack<Pair> stack = new Stack<Pair>();
        stack.add(new Pair((Object)t, (Object)t.label()));
        String originalLabel = t.label();
        while (!stack.isEmpty()) {
            Pair curr = (Pair)stack.pop();
            Tree node = (Tree)curr.getFirst();
            for (Tree child : node.children()) {
                stack.add(new Pair((Object)child, curr.getSecond()));
            }
            if (node.children().size() <= 2) continue;
            ArrayList<String> children = new ArrayList<String>();
            for (int i = 0; i < node.children().size(); ++i) {
                children.add(((Tree)node.children().get(i)).label());
            }
            Tree copy = node.clone();
            node.children().clear();
            Tree currNode = node;
            for (int i = 1; i < children.size() - 1; ++i) {
                Tree newNode;
                if (this.factor.equals("right")) {
                    newNode = new Tree(currNode);
                    List subChildren = children.subList(i, Math.min(i + this.horizontonalMarkov, children.size()));
                    newNode.setLabel(originalLabel + "-" + "(" + StringUtils.join(subChildren, (String)"-"));
                    newNode.setParent(currNode);
                    currNode.children().add(copy.children().remove(0));
                    currNode.firstChild().setParent(currNode);
                    currNode.children().add(newNode);
                    currNode = newNode;
                    continue;
                }
                newNode = new Tree(currNode);
                newNode.setParent(copy.firstChild());
                List childLabels = children.subList(Math.max(children.size() - i - this.horizontonalMarkov, 0), i);
                Collections.reverse(childLabels);
                newNode.setLabel(originalLabel + "-" + "(" + StringUtils.join(childLabels, (String)"-"));
                currNode.children().add(newNode);
                currNode.firstChild().setParent(currNode);
                currNode.children().add(copy.children().remove(copy.children().size() - 1));
                currNode.lastChild().setParent(currNode);
                currNode = newNode;
            }
            currNode.children().addAll(new ArrayList(copy.children()));
        }
        this.addPreTerminal(t);
        return t;
    }

    private void addPreTerminal(Tree t) {
        if (t.isLeaf()) {
            Tree newLeaf = new Tree(t);
            newLeaf.setLabel(t.value());
            t.children().add(newLeaf);
            newLeaf.setParent(t);
        } else {
            for (Tree child : t.children()) {
                this.addPreTerminal(child);
            }
        }
    }

    private void checkState(Tree tree, Set<Tree> nonBinarized) {
        for (Tree t : tree.children()) {
            this.checkState(t, nonBinarized);
        }
        if (tree.children().size() > 2) {
            Tree parent = tree.parent();
            if (parent == null) {
                return;
            }
            nonBinarized.add(tree);
        }
    }
}

