/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.perform.text;

import java.io.Serializable;
import org.deeplearning4j.berkeley.Counter;
import org.deeplearning4j.nn.conf.Configuration;
import org.deeplearning4j.scaleout.job.Job;
import org.deeplearning4j.scaleout.perform.WorkerPerformer;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.deeplearning4j.text.tokenization.tokenizerfactory.DefaultTokenizerFactory;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;

public class WordCountWorkPerformer
implements WorkerPerformer {
    private transient TokenizerFactory tokenizerFactory;
    public static final String TOKENIZER_CLASS = "org.deeplearning4j.scaleout.perform.text.tokenizerfactoryclass";

    public void perform(Job job) {
        String sentence = (String)((Object)job.getWork());
        Counter result = new Counter();
        Tokenizer tokenizer = this.tokenizerFactory.create(sentence);
        while (tokenizer.hasMoreTokens()) {
            result.incrementCount((Object)tokenizer.nextToken(), 1.0);
        }
        job.setResult((Serializable)result);
    }

    public void update(Object ... o) {
    }

    public void setup(Configuration conf) {
        try {
            Class<?> clazz = Class.forName(conf.get(TOKENIZER_CLASS, DefaultTokenizerFactory.class.getName()));
            this.tokenizerFactory = (TokenizerFactory)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

