/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.corpora.treeparser;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.models.rntn.Tree;
import org.deeplearning4j.text.corpora.treeparser.BinarizeTreeTransformer;
import org.deeplearning4j.text.corpora.treeparser.CollapseUnaries;
import org.deeplearning4j.text.corpora.treeparser.TreeParser;
import org.deeplearning4j.text.corpora.treeparser.transformer.TreeTransformer;

public class TreeVectorizer {
    private TreeParser parser;
    private TreeTransformer treeTransformer = new BinarizeTreeTransformer();
    private TreeTransformer cnfTransformer = new CollapseUnaries();

    public TreeVectorizer(TreeParser parser) {
        this.parser = parser;
    }

    public TreeVectorizer() throws Exception {
        this(new TreeParser());
    }

    public List<Tree> getTrees(String sentences) throws Exception {
        ArrayList<Tree> ret = new ArrayList<Tree>();
        List<Tree> baseTrees = this.parser.getTrees(sentences);
        for (Tree t : baseTrees) {
            Tree binarized = this.treeTransformer.transform(t);
            binarized = this.cnfTransformer.transform(binarized);
            ret.add(binarized);
        }
        return ret;
    }

    public List<Tree> getTreesWithLabels(String sentences, String label, List<String> labels) throws Exception {
        ArrayList<Tree> ret = new ArrayList<Tree>();
        List<Tree> baseTrees = this.parser.getTreesWithLabels(sentences, label, labels);
        for (Tree t : baseTrees) {
            Tree binarized = this.treeTransformer.transform(t);
            binarized = this.cnfTransformer.transform(binarized);
            ret.add(binarized);
        }
        return ret;
    }

    public List<Tree> getTreesWithLabels(String sentences, List<String> labels) throws Exception {
        ArrayList<String> realLabels = new ArrayList<String>(labels);
        if (!realLabels.contains("NONE")) {
            realLabels.add("NONE");
        }
        ArrayList<Tree> ret = new ArrayList<Tree>();
        List<Tree> baseTrees = this.parser.getTreesWithLabels(sentences, realLabels);
        for (Tree t : baseTrees) {
            Tree binarized = this.treeTransformer.transform(t);
            binarized = this.cnfTransformer.transform(binarized);
            ret.add(binarized);
        }
        return ret;
    }
}

