/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.convolutional;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Upsampling3D;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;

public class KerasUpsampling3D
extends KerasLayer {
    public KerasUpsampling3D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasUpsampling3D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        int[] size = KerasConvolutionUtils.getUpsamplingSizeFromConfig(layerConfig, 3, this.conf);
        Upsampling3D.Builder builder = ((Upsampling3D.Builder)((Upsampling3D.Builder)new Upsampling3D.Builder().name(this.layerName)).dropOut(this.dropout)).size(size[0]);
        this.layer = builder.build();
        this.vertex = null;
    }

    public Upsampling3D getUpsampling3DLayer() {
        return (Upsampling3D)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Upsampling 3D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getUpsampling3DLayer().getOutputType(-1, inputType[0]);
    }
}

