/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.noise;

import java.util.Map;
import org.deeplearning4j.nn.conf.dropout.GaussianNoise;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.utils.KerasLayerUtils;

public class KerasGaussianNoise
extends KerasLayer {
    public KerasGaussianNoise(Integer kerasVersion) throws UnsupportedKerasConfigurationException {
        super(kerasVersion);
    }

    public KerasGaussianNoise(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasGaussianNoise(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        Map<String, Object> innerConfig = KerasLayerUtils.getInnerLayerConfigFromConfig(layerConfig, this.conf);
        if (!innerConfig.containsKey(this.conf.getLAYER_FIELD_GAUSSIAN_VARIANCE())) {
            throw new InvalidKerasConfigurationException("Keras configuration does not contain " + this.conf.getLAYER_FIELD_GAUSSIAN_VARIANCE() + " parameterneeded for GaussianNoise");
        }
        double stddev = (Double)innerConfig.get(this.conf.getLAYER_FIELD_GAUSSIAN_VARIANCE());
        this.layer = ((DropoutLayer.Builder)((DropoutLayer.Builder)new DropoutLayer.Builder().name(this.layerName)).dropOut((IDropout)new GaussianNoise(stddev))).build();
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Gaussian Noise layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getGaussianNoiseLayer().getOutputType(-1, inputType[0]);
    }

    public DropoutLayer getGaussianNoiseLayer() {
        return (DropoutLayer)this.layer;
    }
}

