/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.hdf5;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hdf5Archive
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Hdf5Archive.class);
    private hdf5.H5File file;
    private static hdf5.DataType dataType;

    public Hdf5Archive(String archiveFilename) {
        this.file = new hdf5.H5File(archiveFilename, hdf5.H5F_ACC_RDONLY());
    }

    @Override
    public void close() {
        this.file.deallocate();
    }

    private hdf5.Group[] openGroups(String ... groups) {
        hdf5.Group[] groupArray = new hdf5.Group[groups.length];
        groupArray[0] = this.file.openGroup(groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            groupArray[i] = groupArray[i - 1].openGroup(groups[i]);
        }
        return groupArray;
    }

    private void closeGroups(hdf5.Group[] groupArray) {
        for (int i = groupArray.length - 1; i >= 0; --i) {
            groupArray[i].deallocate();
        }
    }

    public INDArray readDataSet(String datasetName, String ... groups) throws UnsupportedKerasConfigurationException {
        if (groups.length == 0) {
            return this.readDataSet((hdf5.Group)this.file, datasetName);
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        INDArray a = this.readDataSet(groupArray[groupArray.length - 1], datasetName);
        this.closeGroups(groupArray);
        return a;
    }

    public String readAttributeAsJson(String attributeName, String ... groups) throws UnsupportedKerasConfigurationException {
        if (groups.length == 0) {
            hdf5.Attribute a = this.file.openAttribute(attributeName);
            String s = this.readAttributeAsJson(a);
            a.deallocate();
            return s;
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        hdf5.Attribute a = groupArray[groups.length - 1].openAttribute(attributeName);
        String s = this.readAttributeAsJson(a);
        a.deallocate();
        this.closeGroups(groupArray);
        return s;
    }

    public String readAttributeAsString(String attributeName, String ... groups) throws UnsupportedKerasConfigurationException {
        if (groups.length == 0) {
            hdf5.Attribute a = this.file.openAttribute(attributeName);
            String s = this.readAttributeAsString(a);
            a.deallocate();
            return s;
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        hdf5.Attribute a = groupArray[groups.length - 1].openAttribute(attributeName);
        String s = this.readAttributeAsString(a);
        a.deallocate();
        this.closeGroups(groupArray);
        return s;
    }

    public boolean hasAttribute(String attributeName, String ... groups) {
        if (groups.length == 0) {
            return this.file.attrExists(attributeName);
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        boolean b = groupArray[groupArray.length - 1].attrExists(attributeName);
        this.closeGroups(groupArray);
        return b;
    }

    public List<String> getDataSets(String ... groups) {
        if (groups.length == 0) {
            return this.getObjects((hdf5.Group)this.file, 1);
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        List<String> ls = this.getObjects(groupArray[groupArray.length - 1], 1);
        this.closeGroups(groupArray);
        return ls;
    }

    public List<String> getGroups(String ... groups) {
        if (groups.length == 0) {
            return this.getObjects((hdf5.Group)this.file, 0);
        }
        hdf5.Group[] groupArray = this.openGroups(groups);
        List<String> ls = this.getObjects(groupArray[groupArray.length - 1], 0);
        this.closeGroups(groupArray);
        return ls;
    }

    private INDArray readDataSet(hdf5.Group fileGroup, String datasetName) throws UnsupportedKerasConfigurationException {
        INDArray data;
        hdf5.DataSet dataset = fileGroup.openDataSet(datasetName);
        hdf5.DataSpace space = dataset.getSpace();
        int nbDims = space.getSimpleExtentNdims();
        long[] dims = new long[nbDims];
        space.getSimpleExtentDims(dims);
        switch (nbDims) {
            case 4: {
                float[] dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2] * dims[3])];
                FloatPointer fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2], (int)dims[3]});
                int j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        int i3 = 0;
                        while ((long)i3 < dims[2]) {
                            int i4 = 0;
                            while ((long)i4 < dims[3]) {
                                data.putScalar(i1, i2, i3, i4, (double)dataBuffer[j++]);
                                ++i4;
                            }
                            ++i3;
                        }
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 3: {
                float[] dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2])];
                FloatPointer fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2]});
                int j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        int i3 = 0;
                        while ((long)i3 < dims[2]) {
                            data.putScalar(i1, i2, i3, (double)dataBuffer[j++]);
                            ++i3;
                        }
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 2: {
                float[] dataBuffer = new float[(int)(dims[0] * dims[1])];
                FloatPointer fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int)((int)dims[0]), (int)((int)dims[1]));
                int j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        data.putScalar(i1, i2, (double)dataBuffer[j++]);
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 1: {
                float[] dataBuffer = new float[(int)dims[0]];
                FloatPointer fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int)((int)dims[0]));
                int j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    data.putScalar(i1, dataBuffer[j++]);
                    ++i1;
                }
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Cannot import weights with rank " + nbDims);
            }
        }
        space.deallocate();
        dataset.deallocate();
        return data;
    }

    private List<String> getObjects(hdf5.Group fileGroup, int objType) {
        ArrayList<String> groups = new ArrayList<String>();
        int i = 0;
        while ((long)i < fileGroup.getNumObjs()) {
            BytePointer objPtr = fileGroup.getObjnameByIdx((long)i);
            if (fileGroup.childObjType(objPtr) == objType) {
                groups.add(fileGroup.getObjnameByIdx((long)i).getString());
            }
            ++i;
        }
        return groups;
    }

    private String readAttributeAsJson(hdf5.Attribute attribute) throws UnsupportedKerasConfigurationException {
        String s;
        hdf5.VarLenType vl = attribute.getVarLenType();
        int bufferSizeMult = 1;
        while (true) {
            byte[] attrBuffer = new byte[bufferSizeMult * 2000];
            BytePointer attrPointer = new BytePointer(attrBuffer);
            attribute.read((hdf5.DataType)vl, attrPointer);
            attrPointer.get(attrBuffer);
            s = new String(attrBuffer);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
            try {
                mapper.readTree(s);
            }
            catch (IOException e) {
                log.info(e.getMessage());
                if (++bufferSizeMult <= 1000) continue;
                throw new UnsupportedKerasConfigurationException("Could not read abnormally long HDF5 attribute");
            }
            break;
        }
        vl.deallocate();
        return s;
    }

    private String readAttributeAsString(hdf5.Attribute attribute) throws UnsupportedKerasConfigurationException {
        String s;
        hdf5.VarLenType vl;
        block1: {
            vl = attribute.getVarLenType();
            int bufferSizeMult = 1;
            s = null;
            do {
                byte[] attrBuffer = new byte[bufferSizeMult * 2000];
                BytePointer attrPointer = new BytePointer(attrBuffer);
                attribute.read((hdf5.DataType)vl, attrPointer);
                attrPointer.get(attrBuffer);
                s = new String(attrBuffer);
                if (s.endsWith("\u0000")) break block1;
            } while (++bufferSizeMult <= 1000);
            throw new UnsupportedKerasConfigurationException("Could not read abnormally long HDF5 attribute");
        }
        s = s.replace("\u0000", "");
        vl.deallocate();
        return s;
    }

    public String readAttributeAsFixedLengthString(String attributeName, int bufferSize) throws UnsupportedKerasConfigurationException {
        hdf5.Attribute a = this.file.openAttribute(attributeName);
        String s = this.readAttributeAsFixedLengthString(a, bufferSize);
        a.deallocate();
        return s;
    }

    private String readAttributeAsFixedLengthString(hdf5.Attribute attribute, int bufferSize) throws UnsupportedKerasConfigurationException {
        hdf5.VarLenType vl = attribute.getVarLenType();
        byte[] attrBuffer = new byte[bufferSize];
        BytePointer attrPointer = new BytePointer(attrBuffer);
        attribute.read((hdf5.DataType)vl, attrPointer);
        attrPointer.get(attrBuffer);
        vl.deallocate();
        return new String(attrBuffer);
    }

    static {
        try {
            Loader.load(hdf5.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dataType = new hdf5.DataType(hdf5.PredType.NATIVE_FLOAT());
    }
}

