/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.hdf5;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hdf5Archive {
    private static final Logger log = LoggerFactory.getLogger(Hdf5Archive.class);
    private hdf5.H5File file;
    private hdf5.DataType dataType = new hdf5.DataType(hdf5.PredType.NATIVE_FLOAT());

    public Hdf5Archive(String archiveFilename) {
        this.file = new hdf5.H5File(archiveFilename, hdf5.H5F_ACC_RDONLY);
    }

    public INDArray readDataSet(String datasetName, String ... groups) throws UnsupportedKerasConfigurationException {
        hdf5.CommonFG group = this.file.asCommonFG();
        for (int i = 0; i < groups.length; ++i) {
            group = group.openGroup(groups[i]).asCommonFG();
        }
        return this.readDataSet(group, datasetName);
    }

    public String readAttributeAsJson(String attributeName, String ... groups) throws UnsupportedKerasConfigurationException {
        if (groups.length == 0) {
            return this.readAttributeAsJson(this.file.openAttribute(attributeName));
        }
        hdf5.Group group = this.file.asCommonFG().openGroup(groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            group = group.asCommonFG().openGroup(groups[i]);
        }
        return this.readAttributeAsJson(group.openAttribute(attributeName));
    }

    public boolean hasAttribute(String attributeName, String ... groups) {
        if (groups.length == 0) {
            return this.file.attrExists(attributeName);
        }
        hdf5.Group group = this.file.asCommonFG().openGroup(groups[0]);
        for (int i = 1; i < groups.length; ++i) {
            group = group.asCommonFG().openGroup(groups[i]);
        }
        return group.attrExists(attributeName);
    }

    public List<String> getDataSets(String ... groups) {
        hdf5.CommonFG group = this.file.asCommonFG();
        for (int i = 0; i < groups.length; ++i) {
            group = group.openGroup(groups[i]).asCommonFG();
        }
        return this.getObjects(group, 1);
    }

    public List<String> getGroups(String ... groups) {
        hdf5.CommonFG group = this.file.asCommonFG();
        for (int i = 0; i < groups.length; ++i) {
            group = group.openGroup(groups[i]).asCommonFG();
        }
        return this.getObjects(group, 0);
    }

    private INDArray readDataSet(hdf5.CommonFG fileGroup, String datasetName) throws UnsupportedKerasConfigurationException {
        hdf5.DataSet dataset = fileGroup.openDataSet(datasetName);
        hdf5.DataSpace space = dataset.getSpace();
        int nbDims = space.getSimpleExtentNdims();
        long[] dims = new long[nbDims];
        space.getSimpleExtentDims(dims);
        float[] dataBuffer = null;
        FloatPointer fp = null;
        int j = 0;
        INDArray data = null;
        switch (nbDims) {
            case 4: {
                dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2] * dims[3])];
                fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, this.dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2], (int)dims[3]});
                j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        int i3 = 0;
                        while ((long)i3 < dims[2]) {
                            int i4 = 0;
                            while ((long)i4 < dims[3]) {
                                data.putScalar(i1, i2, i3, i4, (double)dataBuffer[j++]);
                                ++i4;
                            }
                            ++i3;
                        }
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 3: {
                dataBuffer = new float[(int)(dims[0] * dims[1] * dims[2])];
                fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, this.dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int[])new int[]{(int)dims[0], (int)dims[1], (int)dims[2]});
                j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        int i3 = 0;
                        while ((long)i3 < dims[2]) {
                            data.putScalar(i1, i2, i3, (double)dataBuffer[j++]);
                            ++i3;
                        }
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 2: {
                dataBuffer = new float[(int)(dims[0] * dims[1])];
                fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, this.dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int)((int)dims[0]), (int)((int)dims[1]));
                j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    int i2 = 0;
                    while ((long)i2 < dims[1]) {
                        data.putScalar(i1, i2, (double)dataBuffer[j++]);
                        ++i2;
                    }
                    ++i1;
                }
                break;
            }
            case 1: {
                dataBuffer = new float[(int)dims[0]];
                fp = new FloatPointer(dataBuffer);
                dataset.read((Pointer)fp, this.dataType);
                fp.get(dataBuffer);
                data = Nd4j.create((int)((int)dims[0]));
                j = 0;
                int i1 = 0;
                while ((long)i1 < dims[0]) {
                    data.putScalar(i1, dataBuffer[j++]);
                    ++i1;
                }
                break;
            }
            default: {
                throw new UnsupportedKerasConfigurationException("Cannot import weights with rank " + nbDims);
            }
        }
        return data;
    }

    private List<String> getObjects(hdf5.CommonFG fileGroup, int objType) {
        ArrayList<String> groups = new ArrayList<String>();
        int i = 0;
        while ((long)i < fileGroup.getNumObjs()) {
            BytePointer objPtr = fileGroup.getObjnameByIdx((long)i);
            if (fileGroup.childObjType(objPtr) == objType) {
                groups.add(fileGroup.getObjnameByIdx((long)i).getString());
            }
            ++i;
        }
        return groups;
    }

    private String readAttributeAsJson(hdf5.Attribute attribute) throws UnsupportedKerasConfigurationException {
        hdf5.VarLenType vl = attribute.getVarLenType();
        int bufferSizeMult = 1;
        String s = null;
        while (true) {
            byte[] attrBuffer = new byte[bufferSizeMult * 2000];
            BytePointer attrPointer = new BytePointer(attrBuffer);
            attribute.read((hdf5.DataType)vl, attrPointer);
            attrPointer.get(attrBuffer);
            s = new String(attrBuffer);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
            try {
                mapper.readTree(s);
            }
            catch (IOException iOException) {
                if (++bufferSizeMult <= 100) continue;
                throw new UnsupportedKerasConfigurationException("Could not read abnormally long HDF5 attribute");
            }
            break;
        }
        return s;
    }

    static {
        try {
            Loader.load(hdf5.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

