/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras;

import java.io.IOException;
import java.io.InputStream;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.modelimport.keras.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.KerasModel;
import org.deeplearning4j.nn.modelimport.keras.KerasSequentialModel;
import org.deeplearning4j.nn.modelimport.keras.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasModelImport {
    private static final Logger log = LoggerFactory.getLogger(KerasModelImport.class);

    public static ComputationGraph importKerasModelAndWeights(InputStream modelHdf5Stream, boolean enforceTrainingConfig) {
        throw new UnsupportedOperationException("Reading HDF5 files from InputStreams currently unsupported.");
    }

    public static ComputationGraph importKerasModelAndWeights(InputStream modelHdf5Stream) {
        throw new UnsupportedOperationException("Reading HDF5 files from InputStreams currently unsupported.");
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(InputStream modelHdf5Stream, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        throw new UnsupportedOperationException("Reading HDF5 files from InputStreams currently unsupported.");
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(InputStream modelHdf5Stream) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        throw new UnsupportedOperationException("Reading HDF5 files from InputStreams currently unsupported.");
    }

    public static ComputationGraph importKerasModelAndWeights(String modelHdf5Filename, boolean enforceTrainingConfig) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        ComputationGraph model = kerasModel.getComputationGraph();
        return model;
    }

    public static ComputationGraph importKerasModelAndWeights(String modelHdf5Filename) throws IOException, UnsupportedKerasConfigurationException, InvalidKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(true).buildModel();
        ComputationGraph model = kerasModel.getComputationGraph();
        return model;
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        MultiLayerNetwork model = kerasModel.getMultiLayerNetwork();
        return model;
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelHdf5Filename(modelHdf5Filename).enforceTrainingConfig(true).buildSequential();
        MultiLayerNetwork model = kerasModel.getMultiLayerNetwork();
        return model;
    }

    public static ComputationGraph importKerasModelAndWeights(String modelJsonFilename, String weightsHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5Filename(weightsHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        ComputationGraph model = kerasModel.getComputationGraph();
        return model;
    }

    public static ComputationGraph importKerasModelAndWeights(String modelJsonFilename, String weightsHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5Filename(weightsHdf5Filename).enforceTrainingConfig(true).buildModel();
        ComputationGraph model = kerasModel.getComputationGraph();
        return model;
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelJsonFilename, String weightsHdf5Filename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5Filename(weightsHdf5Filename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        MultiLayerNetwork model = kerasModel.getMultiLayerNetwork();
        return model;
    }

    public static MultiLayerNetwork importKerasSequentialModelAndWeights(String modelJsonFilename, String weightsHdf5Filename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).weightsHdf5Filename(weightsHdf5Filename).enforceTrainingConfig(true).buildSequential();
        MultiLayerNetwork model = kerasModel.getMultiLayerNetwork();
        return model;
    }

    public static ComputationGraphConfiguration importKerasModelConfiguration(String modelJsonFilename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(enforceTrainingConfig).buildModel();
        return kerasModel.getComputationGraphConfiguration();
    }

    public static ComputationGraphConfiguration importKerasModelConfiguration(String modelJsonFilename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(true).buildModel();
        return kerasModel.getComputationGraphConfiguration();
    }

    public static MultiLayerConfiguration importKerasSequentialConfiguration(String modelJsonFilename, boolean enforceTrainingConfig) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(enforceTrainingConfig).buildSequential();
        return kerasModel.getMultiLayerConfiguration();
    }

    public static MultiLayerConfiguration importKerasSequentialConfiguration(String modelJsonFilename) throws IOException, InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        KerasSequentialModel kerasModel = new KerasModel.ModelBuilder().modelJsonFilename(modelJsonFilename).enforceTrainingConfig(true).buildSequential();
        return kerasModel.getMultiLayerConfiguration();
    }
}

