/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.graph.iterator.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.deeplearning4j.graph.api.IGraph;
import org.deeplearning4j.graph.api.NoEdgeHandling;
import org.deeplearning4j.graph.iterator.GraphWalkIterator;
import org.deeplearning4j.graph.iterator.WeightedRandomWalkIterator;
import org.deeplearning4j.graph.iterator.parallel.GraphWalkIteratorProvider;

public class WeightedRandomWalkGraphIteratorProvider<V>
implements GraphWalkIteratorProvider<V> {
    private IGraph<V, ? extends Number> graph;
    private int walkLength;
    private Random rng;
    private NoEdgeHandling mode;

    public WeightedRandomWalkGraphIteratorProvider(IGraph<V, ? extends Number> graph, int walkLength) {
        this(graph, walkLength, System.currentTimeMillis(), NoEdgeHandling.EXCEPTION_ON_DISCONNECTED);
    }

    public WeightedRandomWalkGraphIteratorProvider(IGraph<V, ? extends Number> graph, int walkLength, long seed, NoEdgeHandling mode) {
        this.graph = graph;
        this.walkLength = walkLength;
        this.rng = new Random(seed);
        this.mode = mode;
    }

    @Override
    public List<GraphWalkIterator<V>> getGraphWalkIterators(int numIterators) {
        int nVertices = this.graph.numVertices();
        if (numIterators > nVertices) {
            numIterators = nVertices;
        }
        int verticesPerIter = nVertices / numIterators;
        ArrayList<GraphWalkIterator<V>> list = new ArrayList<GraphWalkIterator<V>>(numIterators);
        int last = 0;
        for (int i = 0; i < numIterators; ++i) {
            int from = last;
            int to = Math.min(nVertices, from + verticesPerIter);
            if (i == numIterators - 1) {
                to = nVertices;
            }
            WeightedRandomWalkIterator<V> iter = new WeightedRandomWalkIterator<V>(this.graph, this.walkLength, this.rng.nextLong(), this.mode, from, to);
            list.add(iter);
            last = to;
        }
        return list;
    }
}

