/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.resources.Downloader;

public class IrisUtils {
    private static final String IRIS_RELATIVE_URL = "datasets/iris.dat";
    private static final String MD5 = "1c21400a78061197eac64c6748844216";

    private IrisUtils() {
    }

    public static List<DataSet> loadIris(int from, int to) throws IOException {
        int i;
        List lines;
        File rootDir = DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)"iris");
        File irisData = new File(rootDir, "iris.dat");
        if (!irisData.exists()) {
            URL url = DL4JResources.getURL((String)IRIS_RELATIVE_URL);
            Downloader.download((String)"Iris", (URL)url, (File)irisData, (String)MD5, (int)3);
        }
        try (FileInputStream is = new FileInputStream(irisData);){
            lines = IOUtils.readLines((InputStream)is);
        }
        ArrayList<DataSet> list = new ArrayList<DataSet>();
        INDArray ret = Nd4j.ones((int)Math.abs(to - from), (int)4);
        double[][] outcomes = new double[lines.size()][3];
        int putCount = 0;
        for (i = from; i < to; ++i) {
            String line = (String)lines.get(i);
            String[] split = line.split(",");
            IrisUtils.addRow(ret, putCount++, split);
            String outcome = split[split.length - 1];
            double[] rowOutcome = new double[3];
            rowOutcome[Integer.parseInt((String)outcome)] = 1.0;
            outcomes[i] = rowOutcome;
        }
        for (i = 0; i < ret.rows(); ++i) {
            DataSet add = new DataSet(ret.getRow((long)i), Nd4j.create((double[])outcomes[from + i]));
            list.add(add);
        }
        return list;
    }

    private static void addRow(INDArray ret, int row, String[] line) {
        double[] vector = new double[4];
        for (int i = 0; i < 4; ++i) {
            vector[i] = Double.parseDouble(line[i]);
        }
        ret.putRow((long)row, Nd4j.create((double[])vector));
    }
}

