/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.dbflute.bhv.core.BehaviorCommand;
import org.dbflute.bhv.core.context.ConditionBeanContext;
import org.dbflute.bhv.core.context.InternalMapContext;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.bhv.exception.SQLExceptionHandler;
import org.dbflute.bhv.exception.SQLExceptionResource;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.jdbc.FetchBean;
import org.dbflute.jdbc.StatementConfig;
import org.dbflute.jdbc.StatementFactory;
import org.dbflute.outsidesql.OutsideSqlContext;
import org.dbflute.outsidesql.typed.AutoPagingHandlingPmb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TnStatementFactoryImpl
implements StatementFactory {
    private static final Logger _log = LoggerFactory.getLogger(TnStatementFactoryImpl.class);
    protected StatementConfig _defaultStatementConfig;
    protected boolean _internalDebug;
    protected Integer _cursorSelectFetchSize;
    protected Integer _entitySelectFetchSize;
    protected boolean _usePagingByCursorSkipSynchronizedFetchSize;
    protected Integer _fixedPagingByCursorSkipSynchronizedFetchSize;

    @Override
    public PreparedStatement createPreparedStatement(Connection conn, String sql) {
        StatementConfig config = this.findStatementConfigOnThread();
        int resultSetType = this.getResultSetType(config);
        int resultSetConcurrency = this.getResultSetConcurrency(config);
        if (this.isInternalDebugEnabled()) {
            _log.debug("...Preparing statement:(sql, " + resultSetType + ", " + resultSetConcurrency + ")");
        }
        PreparedStatement ps = this.prepareStatement(conn, sql, resultSetType, resultSetConcurrency);
        this.reflectStatementOptions(ps, config);
        return ps;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to prepare the SQL statement.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected StatementConfig findStatementConfigOnThread() {
        StatementConfig config;
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
            config = cb.getStatementConfig();
        } else if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            config = context.getStatementConfig();
        } else {
            config = InternalMapContext.getUpdateStatementConfig();
        }
        return config;
    }

    protected int getResultSetType(StatementConfig config) {
        int resultSetType;
        if (config != null && config.hasResultSetType()) {
            resultSetType = config.getResultSetType();
        } else {
            int defaultType = 1003;
            resultSetType = this._defaultStatementConfig != null && this._defaultStatementConfig.hasResultSetType() ? (config != null && config.isSuppressDefault() ? 1003 : this._defaultStatementConfig.getResultSetType()) : 1003;
        }
        return resultSetType;
    }

    protected int getResultSetConcurrency(StatementConfig config) {
        return 1007;
    }

    protected void reflectStatementOptions(PreparedStatement ps, StatementConfig config) {
        StatementConfig actualConfig = this.getActualStatementConfig(config);
        this.doReflectStatementOptions(ps, actualConfig);
    }

    protected StatementConfig getActualStatementConfig(StatementConfig config) {
        StatementConfig defaultConfig = this.getActualDefaultConfig(config);
        Integer queryTimeout = this.getActualQueryTimeout(config, defaultConfig);
        Integer fetchSize = this.getActualFetchSize(config, defaultConfig);
        Integer maxRows = this.getActualMaxRows(config, defaultConfig);
        if (queryTimeout == null && fetchSize == null && maxRows == null) {
            return null;
        }
        StatementConfig actualConfig = new StatementConfig();
        actualConfig.queryTimeout(queryTimeout).fetchSize(fetchSize).maxRows(maxRows);
        return actualConfig;
    }

    protected void doReflectStatementOptions(PreparedStatement ps, StatementConfig actualConfig) {
        if (actualConfig == null || !actualConfig.hasStatementOptions()) {
            return;
        }
        try {
            if (actualConfig.hasQueryTimeout()) {
                Integer queryTimeout = actualConfig.getQueryTimeout();
                if (this.isInternalDebugEnabled()) {
                    _log.debug("...Setting queryTimeout of statement: " + queryTimeout);
                }
                ps.setQueryTimeout(queryTimeout);
            }
            if (actualConfig.hasFetchSize()) {
                Integer fetchSize = actualConfig.getFetchSize();
                if (this.isInternalDebugEnabled()) {
                    _log.debug("...Setting fetchSize of statement: " + fetchSize);
                }
                ps.setFetchSize(fetchSize);
            }
            if (actualConfig.hasMaxRows()) {
                Integer maxRows = actualConfig.getMaxRows();
                if (this.isInternalDebugEnabled()) {
                    _log.debug("...Setting maxRows of statement: " + maxRows);
                }
                ps.setMaxRows(maxRows);
            }
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to set the JDBC parameter.");
            this.handleSQLException(e, resource);
        }
    }

    protected StatementConfig getActualDefaultConfig(StatementConfig config) {
        Object defaultConfig = this._defaultStatementConfig != null ? (config != null && config.isSuppressDefault() ? null : this._defaultStatementConfig.createSnapshot()) : null;
        return defaultConfig;
    }

    protected Integer getActualQueryTimeout(StatementConfig config, StatementConfig defaultConfig) {
        Integer queryTimeout = config != null && config.hasQueryTimeout() ? config.getQueryTimeout() : (defaultConfig != null && defaultConfig.hasQueryTimeout() ? defaultConfig.getQueryTimeout() : null);
        return queryTimeout;
    }

    protected Integer getActualFetchSize(StatementConfig config, StatementConfig defaultConfig) {
        if (config != null && config.hasFetchSize()) {
            return config.getFetchSize();
        }
        Integer nextToRequestPriorityFetchSize = this.getNextToRequestPriorityFetchSize();
        if (nextToRequestPriorityFetchSize != null) {
            return nextToRequestPriorityFetchSize;
        }
        Integer commandFetchSize = this.deriveCommandFetchSize(config);
        if (commandFetchSize != null) {
            return commandFetchSize;
        }
        if (defaultConfig != null && defaultConfig.hasFetchSize()) {
            return defaultConfig.getFetchSize();
        }
        return null;
    }

    protected Integer deriveCommandFetchSize(StatementConfig config) {
        BehaviorCommand<?> command = this.getBehaviorCommand();
        Integer cursorSelectFetchSize = this.chooseCursorSelectFetchSize(config);
        if (cursorSelectFetchSize != null && this.isSelectCursorFetchSizeCommand(command)) {
            return cursorSelectFetchSize;
        }
        Integer entitySelectFetchSize = this.chooseEntitySelectFetchSize(config);
        if (entitySelectFetchSize != null && this.canUseEntitySelectFetchSizeCommand(command)) {
            return entitySelectFetchSize;
        }
        Integer pagingByCursorSkipSynchronizedFetchSize = this.extractPagingByCursorSkipSynchronizedFetchSize(config, command);
        if (pagingByCursorSkipSynchronizedFetchSize != null) {
            return pagingByCursorSkipSynchronizedFetchSize;
        }
        return null;
    }

    protected Integer getNextToRequestPriorityFetchSize() {
        return null;
    }

    protected Integer getActualMaxRows(StatementConfig config, StatementConfig defaultConfig) {
        Integer maxRows = config != null && config.hasMaxRows() ? config.getMaxRows() : (defaultConfig != null && defaultConfig.hasMaxRows() ? defaultConfig.getMaxRows() : null);
        return maxRows;
    }

    @Override
    public CallableStatement createCallableStatement(Connection conn, String sql) {
        StatementConfig config = this.findStatementConfigOnThread();
        int resultSetType = this.getResultSetType(config);
        int resultSetConcurrency = this.getResultSetConcurrency(config);
        if (this.isInternalDebugEnabled()) {
            _log.debug("...Preparing callable:(sql, " + resultSetType + ", " + resultSetConcurrency + ")");
        }
        CallableStatement cs = this.prepareCall(conn, sql, resultSetType, resultSetConcurrency);
        this.reflectStatementOptions(cs, config);
        return cs;
    }

    protected CallableStatement prepareCall(Connection conn, String sql, int resultSetType, int resultSetConcurrency) {
        try {
            return conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            SQLExceptionResource resource = this.createSQLExceptionResource();
            resource.setNotice("Failed to prepare the procedure statement.");
            this.handleSQLException(e, resource);
            return null;
        }
    }

    protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
        this.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected SQLExceptionResource createSQLExceptionResource() {
        return new SQLExceptionResource();
    }

    protected BehaviorCommand<?> getBehaviorCommand() {
        return ResourceContext.isExistResourceContextOnThread() ? ResourceContext.behaviorCommand() : null;
    }

    protected Integer chooseCursorSelectFetchSize(StatementConfig config) {
        if (config != null && config.isSuppressDefault()) {
            return null;
        }
        return this._cursorSelectFetchSize;
    }

    protected boolean isSelectCursorFetchSizeCommand(BehaviorCommand<?> command) {
        return command.isSelectCursor();
    }

    protected Integer chooseEntitySelectFetchSize(StatementConfig config) {
        if (config != null && config.isSuppressDefault()) {
            return null;
        }
        return this._entitySelectFetchSize;
    }

    protected boolean canUseEntitySelectFetchSizeCommand(BehaviorCommand<?> command) {
        return this.isFetchBeanSafetyMaxOneSelectCommand(command);
    }

    protected boolean isFetchBeanSafetyMaxOneSelectCommand(BehaviorCommand<?> command) {
        Object pmb;
        if (this.isConditionBeanSelectRows(command)) {
            if (ConditionBeanContext.isExistConditionBeanOnThread()) {
                ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
                return this.judgeFetchBeanSafetyMaxOneSelectCommand(command, cb);
            }
        } else if (command.isOutsideSql() && (pmb = command.getParameterBean()) instanceof FetchBean) {
            return this.judgeFetchBeanSafetyMaxOneSelectCommand(command, (FetchBean)pmb);
        }
        return false;
    }

    protected boolean judgeFetchBeanSafetyMaxOneSelectCommand(BehaviorCommand<?> command, FetchBean fetchBean) {
        int safetyMaxResultSize = fetchBean.getSafetyMaxResultSize();
        return safetyMaxResultSize == 1;
    }

    protected boolean isConditionBeanSelectRows(BehaviorCommand<?> command) {
        return command.isConditionBean() && command.isSelect() && !command.isSelectCount();
    }

    protected Integer extractPagingByCursorSkipSynchronizedFetchSize(StatementConfig config, BehaviorCommand<?> command) {
        Object pmb;
        if (config != null && config.isSuppressDefault()) {
            return null;
        }
        if (!this.isUsePagingByCursorSkipSynchronizedFetchSize()) {
            return null;
        }
        Integer cursorSkipFetchSize = null;
        if (this.isConditionBeanSelectRows(command)) {
            ConditionBean cb;
            if (ConditionBeanContext.isExistConditionBeanOnThread() && this.mightBeCursorSkipConditionBean(cb = ConditionBeanContext.getConditionBeanOnThread())) {
                cursorSkipFetchSize = cb.getFetchSize();
            }
        } else if (command.isOutsideSql() && (pmb = command.getParameterBean()) instanceof AutoPagingHandlingPmb) {
            cursorSkipFetchSize = ((AutoPagingHandlingPmb)pmb).getFetchSize();
        }
        if (cursorSkipFetchSize != null && cursorSkipFetchSize > 0) {
            Integer fixedSize = this.getFixedPagingByCursorSkipSynchronizedFetchSize();
            return fixedSize != null ? fixedSize : cursorSkipFetchSize;
        }
        return null;
    }

    protected boolean mightBeCursorSkipConditionBean(ConditionBean cb) {
        SqlClause sqlClause = cb.getSqlClause();
        return !sqlClause.isFetchStartIndexSupported() || !sqlClause.isFetchSizeSupported();
    }

    protected boolean isUsePagingByCursorSkipSynchronizedFetchSize() {
        return this._usePagingByCursorSkipSynchronizedFetchSize;
    }

    protected Integer getFixedPagingByCursorSkipSynchronizedFetchSize() {
        return this._fixedPagingByCursorSkipSynchronizedFetchSize;
    }

    private boolean isInternalDebugEnabled() {
        return this._internalDebug && _log.isDebugEnabled();
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }

    public void setCursorSelectFetchSize(Integer cursorSelectFetchSize) {
        this._cursorSelectFetchSize = cursorSelectFetchSize;
    }

    public void setEntitySelectFetchSize(Integer entitySelectFetchSize) {
        this._entitySelectFetchSize = entitySelectFetchSize;
    }

    public void setUsePagingByCursorSkipSynchronizedFetchSize(boolean usePagingByCursorSkipSynchronizedFetchSize) {
        this._usePagingByCursorSkipSynchronizedFetchSize = usePagingByCursorSkipSynchronizedFetchSize;
    }

    public void setFixedPagingByCursorSkipSynchronizedFetchSize(Integer fixedPagingByCursorSkipSynchronizedFetchSize) {
        this._fixedPagingByCursorSkipSynchronizedFetchSize = fixedPagingByCursorSkipSynchronizedFetchSize;
    }
}

