/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.identity;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.s2dao.identity.TnIdentifierAssignedGenerator;
import org.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.dbflute.s2dao.identity.TnIdentifierIdentityGenerator;
import org.dbflute.s2dao.metadata.TnPropertyType;
import org.dbflute.util.DfReflectionUtil;

public class TnIdentifierGeneratorFactory {
    private static final Map<String, Class<?>> _generatorClasses = TnIdentifierGeneratorFactory.newConcurrentHashMap();

    private TnIdentifierGeneratorFactory() {
    }

    public static synchronized void addIdentifierGeneratorClass(String name, Class<?> clazz) {
        _generatorClasses.put(name, clazz);
    }

    public static TnIdentifierGenerator createIdentifierGenerator(TnPropertyType propertyType) {
        return TnIdentifierGeneratorFactory.createIdentifierGenerator(propertyType, null);
    }

    public static TnIdentifierGenerator createIdentifierGenerator(TnPropertyType propertyType, String annotation) {
        if (propertyType == null) {
            String msg = "The argument[propertyType] should not be null: annotation=" + annotation;
            throw new IllegalArgumentException(msg);
        }
        if (annotation == null) {
            return new TnIdentifierAssignedGenerator(propertyType);
        }
        String[] array = TnIdentifierGeneratorFactory.tokenize(annotation, "=, ");
        Class<?> clazz = TnIdentifierGeneratorFactory.getGeneratorClass(array[0]);
        TnIdentifierGenerator generator = TnIdentifierGeneratorFactory.createIdentifierGenerator(clazz, propertyType);
        for (int i = 1; i < array.length; i += 2) {
            TnIdentifierGeneratorFactory.setProperty(generator, array[i].trim(), array[i + 1].trim());
        }
        return generator;
    }

    protected static String[] tokenize(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static Class<?> getGeneratorClass(String name) {
        Class<?> clazz = _generatorClasses.get(name);
        if (clazz != null) {
            return clazz;
        }
        return DfReflectionUtil.forName(name);
    }

    protected static TnIdentifierGenerator createIdentifierGenerator(Class<?> clazz, TnPropertyType propertyType) {
        Constructor<?> constructor = DfReflectionUtil.getConstructor(clazz, new Class[]{TnPropertyType.class});
        return (TnIdentifierGenerator)DfReflectionUtil.newInstance(constructor, new Object[]{propertyType});
    }

    protected static void setProperty(TnIdentifierGenerator generator, String propertyName, String value) {
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(generator.getClass());
        DfPropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
        pd.setValue(generator, value);
    }

    protected static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    static {
        TnIdentifierGeneratorFactory.addIdentifierGeneratorClass("assigned", TnIdentifierAssignedGenerator.class);
        TnIdentifierGeneratorFactory.addIdentifierGeneratorClass("identity", TnIdentifierIdentityGenerator.class);
    }
}

