/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.hacomment;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.infra.doc.hacomment.DfHacoMapDiffPart;

public class DfHacoMapPickup {
    public static final String DEFAULT_FORMAT_VERSION = "1.0";
    private static final String HACO_MAP_KEY_HACOMAP = "hacoMap";
    private static final String HACO_MAP_KEY_DIFF_LIST = "diffList";
    protected final String formatVersion;
    protected LocalDateTime pickupDatetime;
    protected final Map<String, List<DfHacoMapDiffPart>> hacoMap = new LinkedHashMap<String, List<DfHacoMapDiffPart>>();

    public DfHacoMapPickup() {
        this(DEFAULT_FORMAT_VERSION);
    }

    public DfHacoMapPickup(String formatVersion) {
        this.hacoMap.put(HACO_MAP_KEY_DIFF_LIST, new ArrayList());
        this.formatVersion = formatVersion;
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap hacoMap = new LinkedHashMap();
        List convertedDiffList = this.getDiffList().stream().map(diffPart -> diffPart.convertPickupMap()).collect(Collectors.toList());
        hacoMap.put(HACO_MAP_KEY_DIFF_LIST, convertedDiffList);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("formatVersion", this.formatVersion);
        map.put("pickupDatetime", this.pickupDatetime);
        map.put(HACO_MAP_KEY_HACOMAP, hacoMap);
        return map;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public void setPickupDatetime(LocalDateTime pickupDatetime) {
        this.pickupDatetime = pickupDatetime;
    }

    public LocalDateTime getPickupDatetime() {
        return this.pickupDatetime;
    }

    public void addAllDiffList(List<DfHacoMapDiffPart> diffPartList) {
        this.getHacoMapDiffPartList().addAll(diffPartList);
    }

    public List<DfHacoMapDiffPart> getDiffList() {
        return Collections.unmodifiableList(this.getHacoMapDiffPartList());
    }

    private List<DfHacoMapDiffPart> getHacoMapDiffPartList() {
        List<DfHacoMapDiffPart> hacoMapDiffPartList = this.hacoMap.get(HACO_MAP_KEY_DIFF_LIST);
        if (hacoMapDiffPartList == null) {
            throw new IllegalStateException("hacoMap history list is not exists");
        }
        return hacoMapDiffPartList;
    }
}

