/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.helper.dfmap.DfMapStyle;
import org.dbflute.infra.doc.decomment.DfDecoMapPieceTargetType;

public class DfDecoMapPiece {
    public static final String DEFAULT_FORMAT_VERSION = "1.1";
    protected final String formatVersion;
    protected final String tableName;
    protected final String columnName;
    protected final DfDecoMapPieceTargetType targetType;
    protected final String decomment;
    protected final String databaseComment;
    protected final Long commentVersion;
    protected final List<String> authorList;
    protected final String pieceCode;
    protected final LocalDateTime pieceDatetime;
    protected final String pieceOwner;
    protected final String pieceGitBranch;
    protected final List<String> previousPieceList;

    public DfDecoMapPiece(String formatVersion, String tableName, String columnName, DfDecoMapPieceTargetType targetType, String decomment, String databaseComment, Long commentVersion, List<String> authorList, String pieceCode, LocalDateTime pieceDatetime, String pieceOwner, String pieceGitBranch, List<String> previousPieceList) {
        this.formatVersion = formatVersion;
        this.tableName = tableName;
        this.columnName = columnName;
        this.targetType = targetType;
        this.decomment = decomment;
        this.databaseComment = databaseComment;
        this.commentVersion = commentVersion;
        this.authorList = new ArrayList<String>(authorList);
        if (!authorList.contains(pieceOwner)) {
            this.authorList.add(pieceOwner);
        }
        this.pieceCode = pieceCode;
        this.pieceDatetime = pieceDatetime;
        this.pieceOwner = pieceOwner;
        this.pieceGitBranch = pieceGitBranch;
        this.previousPieceList = previousPieceList;
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("formatVersion", this.formatVersion);
        map.put("tableName", this.tableName);
        map.put("columnName", this.columnName);
        map.put("targetType", this.targetType.code());
        map.put("decomment", this.decomment);
        map.put("databaseComment", this.databaseComment);
        map.put("commentVersion", this.commentVersion);
        map.put("authorList", this.authorList);
        map.put("pieceCode", this.pieceCode);
        map.put("pieceDatetime", this.pieceDatetime);
        map.put("pieceOwner", this.pieceOwner);
        map.put("pieceGitBranch", this.pieceGitBranch);
        map.put("previousPieceList", this.previousPieceList);
        return map;
    }

    public String toString() {
        return new DfMapStyle().toMapString(this.convertToMap());
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DfDecoMapPieceTargetType getTargetType() {
        return this.targetType;
    }

    public boolean isTargetTypeTable() {
        return this.targetType == DfDecoMapPieceTargetType.Table;
    }

    public boolean isTargetTypeColumn() {
        return this.targetType == DfDecoMapPieceTargetType.Column;
    }

    public String getDecomment() {
        return this.decomment;
    }

    public String getDatabaseComment() {
        return this.databaseComment;
    }

    public Long getCommentVersion() {
        return this.commentVersion;
    }

    public List<String> getAuthorList() {
        return Collections.unmodifiableList(this.authorList);
    }

    public String getPieceCode() {
        return this.pieceCode;
    }

    public LocalDateTime getPieceDatetime() {
        return this.pieceDatetime;
    }

    public String getPieceOwner() {
        return this.pieceOwner;
    }

    public String getPieceGitBranch() {
        return this.pieceGitBranch;
    }

    public List<String> getPreviousPieceList() {
        return Collections.unmodifiableList(this.previousPieceList);
    }
}

