/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.helper.dfmap.DfMapStyle;
import org.dbflute.infra.doc.decomment.DfDecoMapPieceTargetType;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapMappingPart;

public class DfDecoMapMapping {
    public static final String DEFAULT_FORMAT_VERSION = "1.1";
    protected final String formatVersion;
    protected final String oldTableName;
    protected final String oldColumnName;
    protected final String newTableName;
    protected final String newColumnName;
    protected final DfDecoMapPieceTargetType targetType;
    protected final List<String> authorList;
    protected final String mappingCode;
    protected final String mappingOwner;
    protected final LocalDateTime mappingDatetime;
    protected final List<String> previousMappingList;

    public DfDecoMapMapping(String formatVersion, String oldTableName, String oldColumnName, String newTableName, String newColumnName, DfDecoMapPieceTargetType targetType, List<String> authorList, String mappingCode, String mappingOwner, LocalDateTime mappingDatetime, List<String> previousMappingList) {
        this.formatVersion = formatVersion;
        this.oldTableName = oldTableName;
        this.oldColumnName = oldColumnName;
        this.newTableName = newTableName;
        this.newColumnName = newColumnName;
        this.targetType = targetType;
        this.authorList = authorList.stream().distinct().collect(Collectors.toList());
        if (!authorList.contains(mappingOwner)) {
            this.authorList.add(mappingOwner);
        }
        this.mappingCode = mappingCode;
        this.mappingOwner = mappingOwner;
        this.mappingDatetime = mappingDatetime;
        this.previousMappingList = previousMappingList.stream().distinct().collect(Collectors.toList());
    }

    public DfDecoMapMapping(String oldTableName, String oldColumnName, DfDecoMapPieceTargetType type, DfDecoMapMappingPart mappingPart) {
        this.formatVersion = DEFAULT_FORMAT_VERSION;
        this.oldTableName = oldTableName;
        this.oldColumnName = oldColumnName;
        this.newTableName = mappingPart.getNewTableName();
        this.newColumnName = mappingPart.getNewColumnName();
        this.targetType = type;
        this.mappingOwner = mappingPart.getMappingOwner();
        this.authorList = mappingPart.getAuthorList().stream().distinct().collect(Collectors.toList());
        if (!this.authorList.contains(this.mappingOwner)) {
            this.authorList.add(this.mappingOwner);
        }
        this.mappingCode = mappingPart.getMappingCode();
        this.mappingDatetime = mappingPart.getMappingDatetime();
        this.previousMappingList = mappingPart.getPreviousMappingList().stream().distinct().collect(Collectors.toList());
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("formatVersion", this.formatVersion);
        map.put("oldTableName", this.oldTableName);
        map.put("oldColumnName", this.oldColumnName);
        map.put("newTableName", this.newTableName);
        map.put("newColumnName", this.newColumnName);
        map.put("targetType", this.targetType.code());
        map.put("authorList", this.authorList);
        map.put("mappingCode", this.mappingCode);
        map.put("mappingOwner", this.mappingOwner);
        map.put("mappingDatetime", this.mappingDatetime);
        map.put("previousMappingList", this.previousMappingList);
        return map;
    }

    public String toString() {
        return new DfMapStyle().toMapString(this.convertToMap());
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public DfDecoMapPieceTargetType getTargetType() {
        return this.targetType;
    }

    public boolean isTargetTypeTable() {
        return this.targetType == DfDecoMapPieceTargetType.Table;
    }

    public boolean isTargetTypeColumn() {
        return this.targetType == DfDecoMapPieceTargetType.Column;
    }

    public List<String> getAuthorList() {
        return Collections.unmodifiableList(this.authorList);
    }

    public String getMappingCode() {
        return this.mappingCode;
    }

    public String getMappingOwner() {
        return this.mappingOwner;
    }

    public LocalDateTime getMappingDatetime() {
        return this.mappingDatetime;
    }

    public List<String> getPreviousMappingList() {
        return Collections.unmodifiableList(this.previousMappingList);
    }
}

