/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.dfprop;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.exception.DfPropFileReadFailureException;
import org.dbflute.helper.dfmap.DfMapFile;
import org.dbflute.helper.dfmap.exception.DfMapDuplicateEntryException;
import org.dbflute.helper.dfmap.exception.DfMapParseFailureException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.infra.dfprop.DfPropReadingListHandler;
import org.dbflute.infra.dfprop.DfPropReadingMapHandler;
import org.dbflute.infra.dfprop.DfPropReadingStringHandler;
import org.dbflute.util.Srl;

public class DfPropFile {
    protected boolean _returnsNullIfNotFound;
    protected boolean _skipLineSeparator;
    protected boolean _checkDuplicateEntry;

    public Map<String, Object> readMap(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadMap(dfpropPath, envType, new DfPropReadingMapHandler<Object>(){

            @Override
            public Map<String, Object> readMap(String path) throws FileNotFoundException, IOException {
                return DfPropFile.this.actuallyReadMap(path);
            }
        });
    }

    protected Map<String, Object> actuallyReadMap(String path) throws FileNotFoundException, IOException {
        try {
            return this.createMapFileStructural().readMap(this.createInputStream(path));
        }
        catch (DfMapDuplicateEntryException e) {
            this.throwDfPropDuplicateEntryException(path, e);
            return null;
        }
        catch (DfMapParseFailureException e) {
            this.throwDfPropMapStringParseFailureException(path, e);
            return null;
        }
    }

    protected void throwDfPropDuplicateEntryException(String path, DfMapDuplicateEntryException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Duplicate entry in the map file.");
        br.addItem("Advice");
        br.addElement("The entry keys in the map string should be unique.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    Sea = map:{");
        br.addElement("        ; ...");
        br.addElement("    }");
        br.addElement("    Sea = map:{");
        br.addElement("        ; ...");
        br.addElement("    }");
        br.addElement("  (o):");
        br.addElement("    Land = map:{");
        br.addElement("        ; ...");
        br.addElement("    }");
        br.addElement("    Sea = map:{");
        br.addElement("        ; ...");
        br.addElement("    }");
        br.addItem("DfProp Path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    protected void throwDfPropMapStringParseFailureException(String path, DfMapParseFailureException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse the map file.");
        br.addItem("Advice");
        br.addElement("Make sure your map file format.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    map:{");
        br.addElement("        ; map:{");
        br.addElement("            ...");
        br.addElement("    }");
        br.addElement("  (o):");
        br.addElement("    map:{");
        br.addElement("        ; map:{");
        br.addElement("            ...");
        br.addElement("        }");
        br.addElement("    }");
        br.addItem("DfProp Path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    public Map<String, String> readMapAsStringValue(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadMap(dfpropPath, envType, new DfPropReadingMapHandler<String>(){

            @Override
            public Map<String, String> readMap(String path) throws FileNotFoundException, IOException {
                return DfPropFile.this.actuallyReadMapAsStringValue(path);
            }
        });
    }

    protected Map<String, String> actuallyReadMapAsStringValue(String path) throws FileNotFoundException, IOException {
        try {
            return this.createMapFileStructural().readMap(this.createInputStream(path), String.class);
        }
        catch (DfMapDuplicateEntryException e) {
            this.throwDfPropDuplicateEntryException(path, e);
            return null;
        }
    }

    public Map<String, List<String>> readMapAsStringListValue(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadMap(dfpropPath, envType, new DfPropReadingMapHandler<List<String>>(){

            @Override
            public Map<String, List<String>> readMap(String path) throws IOException {
                return DfPropFile.this.actuallyReadMapAsStringListValue(path);
            }
        });
    }

    protected Map<String, List<String>> actuallyReadMapAsStringListValue(String path) throws FileNotFoundException, IOException {
        try {
            DfMapFile mapFile = this.createMapFileStructural();
            Map<String, Object> readMap = mapFile.readMap(this.createInputStream(path), Object.class);
            return this.convertToStringListMap(readMap);
        }
        catch (DfMapDuplicateEntryException e) {
            this.throwDfPropDuplicateEntryException(path, e);
            return null;
        }
    }

    protected Map<String, List<String>> convertToStringListMap(Map<String, Object> readMap) {
        LinkedHashMap<String, List<String>> resultMap = new LinkedHashMap<String, List<String>>();
        Set<Map.Entry<String, Object>> entrySet = readMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            List listValue = (List)entry.getValue();
            resultMap.put(entry.getKey(), listValue);
        }
        return resultMap;
    }

    public Map<String, Map<String, String>> readMapAsStringMapValue(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadMap(dfpropPath, envType, new DfPropReadingMapHandler<Map<String, String>>(){

            @Override
            public Map<String, Map<String, String>> readMap(String path) throws IOException {
                return DfPropFile.this.actuallyReadMapAsStringMapValue(path);
            }
        });
    }

    protected Map<String, Map<String, String>> actuallyReadMapAsStringMapValue(String path) throws FileNotFoundException, IOException {
        try {
            DfMapFile mapFile = this.createMapFileStructural();
            Map<String, Object> readMap = mapFile.readMap(this.createInputStream(path), Object.class);
            return this.convertToStringMapValue(readMap);
        }
        catch (DfMapDuplicateEntryException e) {
            this.throwDfPropDuplicateEntryException(path, e);
            return null;
        }
    }

    protected Map<String, Map<String, String>> convertToStringMapValue(Map<String, Object> readMap) {
        LinkedHashMap<String, Map<String, String>> resultMap = new LinkedHashMap<String, Map<String, String>>();
        Set<Map.Entry<String, Object>> entrySet = readMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Map stringMapValue = (Map)entry.getValue();
            resultMap.put(entry.getKey(), stringMapValue);
        }
        return resultMap;
    }

    public List<Object> readList(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadList(dfpropPath, envType, new DfPropReadingListHandler<Object>(){

            @Override
            public List<Object> readList(String path) throws FileNotFoundException, IOException {
                return DfPropFile.this.actuallyReadList(path);
            }
        });
    }

    protected List<Object> actuallyReadList(String path) throws FileNotFoundException, IOException {
        try {
            return this.createMapFileStructural().readList(this.createInputStream(path));
        }
        catch (DfMapDuplicateEntryException e) {
            this.throwDfPropDuplicateEntryException(path, e);
            return null;
        }
    }

    public String readString(String dfpropPath, String envType) {
        this.assertDfpropPath(dfpropPath);
        return this.doReadString(dfpropPath, envType, new DfPropReadingStringHandler(){

            @Override
            public String readString(String path) throws FileNotFoundException, IOException {
                return DfPropFile.this.actuallyReadString(path);
            }
        });
    }

    protected String actuallyReadString(String path) throws FileNotFoundException, IOException {
        return this.createMapFilePlain().readString(this.createInputStream(path));
    }

    protected <ELEMENT> Map<String, ELEMENT> doReadMap(String dfpropPath, String envType, DfPropReadingMapHandler<ELEMENT> handler) {
        Map<String, ELEMENT> map = null;
        if (envType != null) {
            String envPath = this.deriveEnvPath(dfpropPath, envType);
            map = this.callReadingMapChecked(handler, envPath);
            if (map != null) {
                this.resolveOutsidePropInheritMap(handler, envPath, map);
            } else {
                map = this.callReadingMapChecked(handler, dfpropPath);
                if (map != null) {
                    this.resolveOutsidePropInheritMap(handler, dfpropPath, map);
                    this.resolveOutsidePropInheritMap(handler, envPath, map);
                }
            }
        } else {
            map = this.callReadingMapChecked(handler, dfpropPath);
            if (map != null) {
                this.resolveOutsidePropInheritMap(handler, dfpropPath, map);
            }
        }
        if (map == null && !this._returnsNullIfNotFound) {
            map = new LinkedHashMap<String, ELEMENT>(2);
        }
        return map;
    }

    protected <ELEMENT> Map<String, ELEMENT> callReadingMapChecked(DfPropReadingMapHandler<ELEMENT> handler, String path) {
        try {
            return handler.readMap(path);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
        catch (IOException e) {
            this.throwDfPropFileReadFailureException(path, e);
            return null;
        }
    }

    protected <ELEMENT> boolean resolveOutsidePropInheritMap(DfPropReadingMapHandler<ELEMENT> handler, String path, Map<String, ELEMENT> map) {
        if (map == null) {
            return false;
        }
        String inheritPath = this.deriveInheritPath(path);
        if (inheritPath == null) {
            return false;
        }
        Map<String, ELEMENT> inheritMap = this.callReadingMapChecked(handler, inheritPath);
        if (inheritMap == null) {
            return false;
        }
        map.putAll(inheritMap);
        return true;
    }

    protected <ELEMENT> List<ELEMENT> doReadList(String dfpropPath, String envType, DfPropReadingListHandler<ELEMENT> handler) {
        List<ELEMENT> list = null;
        if (envType != null) {
            String envPath = this.deriveEnvPath(dfpropPath, envType);
            list = this.callReadingListChecked(handler, envPath);
            if (list == null) {
                list = this.callReadingListChecked(handler, dfpropPath);
            }
        } else {
            list = this.callReadingListChecked(handler, dfpropPath);
        }
        if (list == null && !this._returnsNullIfNotFound) {
            list = new ArrayList<ELEMENT>(2);
        }
        return list;
    }

    protected <ELEMENT> List<ELEMENT> callReadingListChecked(DfPropReadingListHandler<ELEMENT> handler, String path) {
        try {
            return handler.readList(path);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
        catch (IOException e) {
            this.throwDfPropFileReadFailureException(path, e);
            return null;
        }
    }

    protected String doReadString(String dfpropPath, String envType, DfPropReadingStringHandler handler) {
        String str = null;
        if (envType != null) {
            String envPath = this.deriveEnvPath(dfpropPath, envType);
            str = this.callReadingStringChecked(handler, envPath);
            if (str == null) {
                str = this.callReadingStringChecked(handler, dfpropPath);
            }
        } else {
            str = this.callReadingStringChecked(handler, dfpropPath);
        }
        if (str == null && !this._returnsNullIfNotFound) {
            str = "";
        }
        return str;
    }

    protected String callReadingStringChecked(DfPropReadingStringHandler handler, String envPath) {
        try {
            return handler.readString(envPath);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
        catch (IOException e) {
            this.throwDfPropFileReadFailureException(envPath, e);
            return null;
        }
    }

    protected String deriveEnvPath(String dfpropPath, String envType) {
        String pureFileName;
        String basePath;
        if (dfpropPath.contains("/")) {
            basePath = Srl.substringLastFront(dfpropPath, "/");
            pureFileName = Srl.substringLastRear(dfpropPath, "/");
        } else {
            basePath = ".";
            pureFileName = dfpropPath;
        }
        return basePath + "/" + envType + "/" + pureFileName;
    }

    protected String deriveInheritPath(String path) {
        String allowedExt = this.getInheritAllowedExt();
        if (!path.endsWith(allowedExt)) {
            return null;
        }
        return path.substring(0, path.length() - allowedExt.length()) + "+" + allowedExt;
    }

    protected String getInheritAllowedExt() {
        return ".dfprop";
    }

    protected InputStream createInputStream(String path) throws FileNotFoundException {
        return new FileInputStream(path);
    }

    protected void throwDfPropFileReadFailureException(String path, IOException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the DBFlute property file.");
        br.addItem("Advice");
        br.addElement("Make sure the map-string is correct in the file.");
        br.addElement("For exapmle, the number of start and end braces are the same.");
        br.addItem("DBFlute Property");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    protected DfMapFile createMapFilePlain() {
        DfMapFile mapListFile = this.newMapFile();
        if (this._checkDuplicateEntry) {
            mapListFile.checkDuplicateEntry();
        }
        return mapListFile;
    }

    protected DfMapFile createMapFileStructural() {
        DfMapFile file = this.createMapFilePlain();
        if (this._skipLineSeparator) {
            file.skipLineSeparator();
        }
        return file;
    }

    protected DfMapFile newMapFile() {
        return new DfMapFile();
    }

    protected void assertDfpropPath(String dfpropPath) {
        if (dfpropPath == null || dfpropPath.trim().length() == 0) {
            String msg = "The argument 'dfpropPath' should not be null or empty: " + dfpropPath;
            throw new IllegalArgumentException(msg);
        }
    }

    public DfPropFile returnsNullIfNotFound() {
        this._returnsNullIfNotFound = true;
        return this;
    }

    public DfPropFile skipLineSeparator() {
        this._skipLineSeparator = true;
        return this;
    }

    public DfPropFile checkDuplicateEntry() {
        this._checkDuplicateEntry = true;
        return this;
    }
}

