/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.thread;

import org.dbflute.helper.thread.CountDownRaceLatch;
import org.dbflute.optional.OptionalThing;

public class CountDownRaceRunner {
    protected final long _threadId;
    protected final CountDownRaceLatch _ourLatch;
    protected final int _entryNumber;
    protected final Object _parameter;
    protected final Object _lockObj;
    protected final int _countOfEntry;

    public CountDownRaceRunner(long threadId, CountDownRaceLatch ourLatch, int entryNumber, Object parameter, Object lockObj, int countOfEntry) {
        this._threadId = threadId;
        this._ourLatch = ourLatch;
        this._entryNumber = entryNumber;
        this._parameter = parameter;
        this._lockObj = lockObj;
        this._countOfEntry = countOfEntry;
    }

    public void teaBreak(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            String msg = "Failed to have a tea break but I want to...";
            throw new IllegalStateException(msg, e);
        }
    }

    public void restart() {
        this._ourLatch.await();
    }

    public boolean isEntryNumber(int entryNumber) {
        this.checkEntryNumber(entryNumber);
        return this._entryNumber == entryNumber;
    }

    protected void checkEntryNumber(int entryNumber) {
        if (entryNumber > this._countOfEntry) {
            String msg = "The specified entry number is over count of entries: entryNumber=" + entryNumber + ", countOfEntry=" + this._countOfEntry;
            throw new IllegalArgumentException(msg);
        }
    }

    public long getThreadId() {
        return this._threadId;
    }

    public CountDownRaceLatch getOurLatch() {
        return this._ourLatch;
    }

    public int getEntryNumber() {
        return this._entryNumber;
    }

    public OptionalThing<Object> getParameter() {
        return OptionalThing.ofNullable(this._parameter, () -> {
            throw new IllegalStateException("Not found the parameter for the runner: " + this._entryNumber);
        });
    }

    public Object getLockObj() {
        return this._lockObj;
    }
}

