/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.accessory;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dbflute.util.DfCollectionUtil;

public class EntityModifiedProperties
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected Set<String> _propertyNameSet;

    public void addPropertyName(String propertyName) {
        this.assertPropertyNameNotNull(propertyName);
        this.getPropertyNameSet().add(propertyName);
    }

    protected void assertPropertyNameNotNull(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The argument 'propertyName' should not be null.");
        }
    }

    public Set<String> getPropertyNames() {
        if (this._propertyNameSet != null) {
            return Collections.unmodifiableSet(this._propertyNameSet);
        }
        return DfCollectionUtil.emptySet();
    }

    public boolean isModifiedProperty(String propertyName) {
        return this._propertyNameSet != null && this._propertyNameSet.contains(propertyName);
    }

    public boolean isEmpty() {
        return this._propertyNameSet == null || this.getPropertyNameSet().isEmpty();
    }

    public void clear() {
        if (this._propertyNameSet != null) {
            this.getPropertyNameSet().clear();
        }
    }

    public void remove(String propertyName) {
        this.assertPropertyNameNotNull(propertyName);
        if (this._propertyNameSet != null) {
            this.getPropertyNameSet().remove(propertyName);
        }
    }

    public void accept(EntityModifiedProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("The argument 'properties' should not be null.");
        }
        this.clear();
        for (String propertyName : properties.getPropertyNames()) {
            this.addPropertyName(propertyName);
        }
    }

    protected Set<String> getPropertyNameSet() {
        if (this._propertyNameSet == null) {
            this._propertyNameSet = this.newPropertyNameSet();
        }
        return this._propertyNameSet;
    }

    protected LinkedHashSet<String> newPropertyNameSet() {
        return new LinkedHashSet<String>();
    }

    public String toString() {
        return "modifiedProp:" + this._propertyNameSet;
    }

    public EntityModifiedProperties clone() {
        try {
            EntityModifiedProperties cloned = (EntityModifiedProperties)super.clone();
            if (this._propertyNameSet != null) {
                LinkedHashSet<String> copied = this.newPropertyNameSet();
                copied.addAll(this._propertyNameSet);
                cloned._propertyNameSet = copied;
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone the properties: " + this.toString(), e);
        }
    }
}

