/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.ckey;

import java.util.List;
import org.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.dbflute.cbean.ckey.ConditionKey;
import org.dbflute.cbean.ckey.ConditionKeyPrepareResult;
import org.dbflute.cbean.coption.ConditionOption;
import org.dbflute.cbean.coption.LikeSearchOption;
import org.dbflute.cbean.cvalue.ConditionValue;
import org.dbflute.cbean.sqlclause.query.QueryClause;
import org.dbflute.dbmeta.name.ColumnRealName;

public class ConditionKeyLikeSearch
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLikeSearch() {
        this._conditionKey = this.defineConditionKey();
        this._operand = this.defineOperand();
    }

    protected String defineConditionKey() {
        return "likeSearch";
    }

    protected String defineOperand() {
        return "like";
    }

    @Override
    protected ConditionKeyPrepareResult doPrepareQuery(ConditionValue cvalue, Object value) {
        return this.chooseResultNonFixedQuery(value);
    }

    @Override
    public boolean needsOverrideValue(ConditionValue cvalue) {
        return false;
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        this.assertLikeSearchOption(columnRealName, value, option);
        conditionList.add(this.buildBindClause(columnRealName, this.getLocation(value), cipher, option));
    }

    protected void assertLikeSearchOption(ColumnRealName columnRealName, ConditionValue value, ConditionOption option) {
        if (option == null) {
            String msg = "The argument 'option' should not be null:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (!(option instanceof LikeSearchOption)) {
            String msg = "The argument 'option' should be LikeSearchOption:";
            msg = msg + " columnName=" + columnRealName + " value=" + value;
            msg = msg + " option=" + option;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String getLocation(ConditionValue value) {
        return value.getLikeSearchLatestLocation();
    }

    @Override
    protected boolean isOutOfBindEncryptConditionKey() {
        return true;
    }

    @Override
    protected void doSetupConditionValue(ConditionValue cvalue, Object value, String location, ConditionOption option) {
        cvalue.setupLikeSearch((String)value, (LikeSearchOption)option, location);
    }

    @Override
    public boolean isNullaleKey() {
        return false;
    }
}

