/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import org.dbflute.bhv.exception.BehaviorExceptionThrower;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpSLSExecutor;
import org.dbflute.cbean.coption.FunctionFilterOptionCall;
import org.dbflute.cbean.coption.ScalarSelectOption;
import org.dbflute.cbean.exception.ConditionBeanExceptionThrower;
import org.dbflute.cbean.scoping.ScalarQuery;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.clause.SelectClauseType;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.optional.OptionalScalar;

public class HpSLSFunction<CB extends ConditionBean, RESULT> {
    protected final CB _conditionBean;
    protected final Class<RESULT> _resultType;
    protected final HpSLSExecutor<CB, RESULT> _executor;

    public HpSLSFunction(CB conditionBean, Class<RESULT> resultType, HpSLSExecutor<CB, RESULT> executor) {
        this._conditionBean = conditionBean;
        this._resultType = resultType;
        this._executor = executor;
    }

    public RESULT count(ScalarQuery<CB> cbLambda) {
        return this.doCount(cbLambda, null);
    }

    public RESULT count(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doCount(cbLambda, this.prepareOption(opLambda));
    }

    protected RESULT doCount(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.UNIQUE_COUNT, option);
    }

    public RESULT countDistinct(ScalarQuery<CB> cbLambda) {
        return this.doCountDistinct(cbLambda, null);
    }

    public RESULT countDistinct(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doCountDistinct(cbLambda, this.prepareOption(opLambda));
    }

    protected RESULT doCountDistinct(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.COUNT_DISTINCT, option);
    }

    public OptionalScalar<RESULT> max(ScalarQuery<CB> cbLambda) {
        return this.doMax(cbLambda, null);
    }

    public OptionalScalar<RESULT> max(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doMax(cbLambda, this.prepareOption(opLambda));
    }

    protected OptionalScalar<RESULT> doMax(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.optionalOf("max", this.exec(scalarQuery, SelectClauseType.MAX, option));
    }

    public OptionalScalar<RESULT> min(ScalarQuery<CB> cbLambda) {
        return this.doMin(cbLambda, null);
    }

    public OptionalScalar<RESULT> min(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doMin(cbLambda, this.prepareOption(opLambda));
    }

    protected OptionalScalar<RESULT> doMin(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.optionalOf("min", this.exec(scalarQuery, SelectClauseType.MIN, option));
    }

    public OptionalScalar<RESULT> sum(ScalarQuery<CB> cbLambda) {
        return this.doSum(cbLambda, null);
    }

    public OptionalScalar<RESULT> sum(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doSum(cbLambda, this.prepareOption(opLambda));
    }

    protected OptionalScalar<RESULT> doSum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.optionalOf("sum", this.exec(scalarQuery, SelectClauseType.SUM, option));
    }

    public OptionalScalar<RESULT> avg(ScalarQuery<CB> cbLambda) {
        return this.doAvg(cbLambda, null);
    }

    public OptionalScalar<RESULT> avg(ScalarQuery<CB> cbLambda, FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        return this.doAvg(cbLambda, this.prepareOption(opLambda));
    }

    protected OptionalScalar<RESULT> doAvg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.optionalOf("avg", this.exec(scalarQuery, SelectClauseType.AVG, option));
    }

    protected OptionalScalar<RESULT> optionalOf(String title, RESULT result) {
        return OptionalScalar.ofNullable(result, () -> this.throwScalarSelectValueNotFoundException(title));
    }

    protected void throwScalarSelectValueNotFoundException(String title) {
        this.createBhvExThrower().throwScalarSelectValueNotFoundException(title, (ConditionBean)this._conditionBean, this._resultType);
    }

    protected RESULT exec(ScalarQuery<CB> scalarQuery, SelectClauseType selectClauseType, ScalarSelectOption option) {
        this.assertObjectNotNull("scalarQuery", scalarQuery);
        this.assertObjectNotNull("selectClauseType", (Object)selectClauseType);
        this.assertObjectNotNull("conditionBean", this._conditionBean);
        this.assertObjectNotNull("resultType", this._resultType);
        scalarQuery.query(this._conditionBean);
        this.setupTargetColumnInfo(option);
        this.setupScalarSelectOption(option);
        this.assertScalarSelectRequiredSpecifyColumn();
        return this._executor.execute(this._conditionBean, this._resultType, selectClauseType);
    }

    protected void setupTargetColumnInfo(ScalarSelectOption option) {
        if (option == null) {
            return;
        }
        SqlClause sqlClause = this._conditionBean.getSqlClause();
        ColumnInfo columnInfo = sqlClause.getSpecifiedColumnInfoAsOne();
        if (columnInfo != null) {
            columnInfo = sqlClause.getSpecifiedDerivingColumnInfoAsOne();
        }
        option.xsetTargetColumnInfo(columnInfo);
    }

    protected void setupScalarSelectOption(ScalarSelectOption option) {
        if (option != null) {
            this._conditionBean.xacceptScalarSelectOption(option);
            this._conditionBean.localCQ().xregisterParameterOption(option);
        }
    }

    protected void assertScalarSelectRequiredSpecifyColumn() {
        SqlClause sqlClause = this._conditionBean.getSqlClause();
        String columnName = sqlClause.getSpecifiedColumnDbNameAsOne();
        String subQuery = sqlClause.getSpecifiedDerivingSubQueryAsOne();
        if (columnName != null && subQuery != null || columnName == null && subQuery == null) {
            this.throwScalarSelectInvalidColumnSpecificationException();
        }
    }

    protected void throwScalarSelectInvalidColumnSpecificationException() {
        this.createCBExThrower().throwScalarSelectInvalidColumnSpecificationException((ConditionBean)this._conditionBean, this._resultType);
    }

    protected ScalarSelectOption prepareOption(FunctionFilterOptionCall<ScalarSelectOption> opLambda) {
        this.assertObjectNotNull("opLambda", opLambda);
        ScalarSelectOption option = this.createScalarSelectOption();
        opLambda.callback(option);
        this.assertScalarSelectOption(option);
        return option;
    }

    protected ScalarSelectOption createScalarSelectOption() {
        return this.newScalarSelectOption();
    }

    protected ScalarSelectOption newScalarSelectOption() {
        return new ScalarSelectOption();
    }

    protected BehaviorExceptionThrower createBhvExThrower() {
        return new BehaviorExceptionThrower();
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected void assertScalarQuery(ScalarQuery<?> scalarQuery) {
        if (scalarQuery == null) {
            String msg = "The argument 'scalarQuery' for ScalarSelect should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertScalarSelectOption(ScalarSelectOption option) {
        if (option == null) {
            String msg = "The argument 'option' for ScalarSelect should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

